/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.serviceregistry;

import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;

public class ServiceInstanceRegistration
implements ZookeeperRegistration {
    protected ServiceInstance<ZookeeperInstance> serviceInstance;
    protected ServiceInstanceBuilder<ZookeeperInstance> builder;

    public static RegistrationBuilder builder() {
        try {
            return new RegistrationBuilder((ServiceInstanceBuilder<ZookeeperInstance>)ServiceInstance.builder());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating ServiceInstanceBuilder", e);
        }
    }

    public static RegistrationBuilder builder(ServiceInstanceBuilder<ZookeeperInstance> builder) {
        return new RegistrationBuilder(builder);
    }

    public ServiceInstanceRegistration(ServiceInstanceBuilder<ZookeeperInstance> builder) {
        this.builder = builder;
    }

    @Override
    public ServiceInstance<ZookeeperInstance> getServiceInstance() {
        if (this.serviceInstance == null) {
            this.build();
        }
        return this.serviceInstance;
    }

    protected void build() {
        this.serviceInstance = this.builder.build();
    }

    public String getServiceId() {
        if (this.serviceInstance == null) {
            return null;
        }
        return this.serviceInstance.getName();
    }

    @Override
    public int getPort() {
        if (this.serviceInstance == null) {
            return 0;
        }
        return this.serviceInstance.getPort();
    }

    @Override
    public void setPort(int port) {
        this.builder.port(port);
        this.build();
    }

    public static class RegistrationBuilder {
        protected ServiceInstanceBuilder<ZookeeperInstance> builder;

        public RegistrationBuilder(ServiceInstanceBuilder<ZookeeperInstance> builder) {
            this.builder = builder;
        }

        public ServiceInstanceRegistration build() {
            return new ServiceInstanceRegistration(this.builder);
        }

        public RegistrationBuilder name(String name) {
            this.builder.name(name);
            return this;
        }

        public RegistrationBuilder address(String address) {
            this.builder.address(address);
            return this;
        }

        public RegistrationBuilder id(String id) {
            this.builder.id(id);
            return this;
        }

        public RegistrationBuilder port(int port) {
            this.builder.port(port);
            return this;
        }

        public RegistrationBuilder sslPort(int port) {
            this.builder.sslPort(port);
            return this;
        }

        public RegistrationBuilder payload(ZookeeperInstance payload) {
            this.builder.payload((Object)payload);
            return this;
        }

        public RegistrationBuilder serviceType(ServiceType serviceType) {
            this.builder.serviceType(serviceType);
            return this;
        }

        public RegistrationBuilder registrationTimeUTC(long registrationTimeUTC) {
            this.builder.registrationTimeUTC(registrationTimeUTC);
            return this;
        }

        public RegistrationBuilder uriSpec(UriSpec uriSpec) {
            this.builder.uriSpec(uriSpec);
            return this;
        }

        public RegistrationBuilder uriSpec(String uriSpec) {
            this.builder.uriSpec(new UriSpec(uriSpec));
            return this;
        }

        public RegistrationBuilder defaultUriSpec() {
            this.builder.uriSpec(new UriSpec("{scheme}://{address}:{port}"));
            return this;
        }
    }
}

