/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataResource;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.util.StringUtils;

public class ZookeeperConfigDataLoader
implements ConfigDataLoader<ZookeeperConfigDataResource> {
    private final Log log;

    public ZookeeperConfigDataLoader(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(ZookeeperConfigDataLoader.class);
    }

    public ConfigData load(ConfigDataLoaderContext context, ZookeeperConfigDataResource resource) {
        try {
            CuratorFramework curator = (CuratorFramework)context.getBootstrapContext().get(CuratorFramework.class);
            if (curator == null) {
                return null;
            }
            ZookeeperPropertySource propertySource = new ZookeeperPropertySource(resource.getContext(), curator);
            List<ZookeeperPropertySource> propertySources = Collections.singletonList(propertySource);
            return new ConfigData(propertySources, source -> {
                ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
                options.add(ConfigData.Option.IGNORE_IMPORTS);
                options.add(ConfigData.Option.IGNORE_PROFILES);
                if (StringUtils.hasText((String)resource.getProfile())) {
                    options.add(ConfigData.Option.PROFILE_SPECIFIC);
                }
                return ConfigData.Options.of((ConfigData.Option[])options.toArray(new ConfigData.Option[0]));
            });
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error getting properties from zookeeper: " + String.valueOf((Object)resource)), (Throwable)e);
            }
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }
}

