/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySources;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class ZookeeperPropertySourceLocator
implements PropertySourceLocator {
    private ZookeeperConfigProperties properties;
    private CuratorFramework curator;
    private List<String> contexts;
    private static final Log log = LogFactory.getLog(ZookeeperPropertySourceLocator.class);

    public ZookeeperPropertySourceLocator(CuratorFramework curator, ZookeeperConfigProperties properties) {
        this.curator = curator;
        Assert.hasText((String)properties.getName(), (String)"spring.cloud.zookeeper.config.name must not be empty");
        this.properties = properties;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            ZookeeperPropertySources sources = new ZookeeperPropertySources(this.properties, log);
            this.contexts = sources.getAutomaticContexts(profiles);
            CompositePropertySource composite = new CompositePropertySource("zookeeper");
            Collections.reverse(this.contexts);
            for (String propertySourceContext : this.contexts) {
                ZookeeperPropertySource propertySource = sources.createPropertySource(propertySourceContext, true, this.curator);
                composite.addPropertySource((PropertySource)propertySource);
            }
            return composite;
        }
        return null;
    }

    @PreDestroy
    public void destroy() {
    }

    private PropertySource<CuratorFramework> create(String context) {
        return new ZookeeperPropertySource(context, this.curator);
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }
}

