/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.Collections;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataLocation;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;

public class ZookeeperConfigDataLoader
implements ConfigDataLoader<ZookeeperConfigDataLocation> {
    public ConfigData load(ConfigDataLoaderContext context, ZookeeperConfigDataLocation location) {
        try {
            CuratorFramework curator = (CuratorFramework)context.getBootstrapContext().get(CuratorFramework.class);
            ZookeeperPropertySource propertySource = new ZookeeperPropertySource(location.getContext(), curator);
            return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            throw new ConfigDataLocationNotFoundException((ConfigDataLocation)location, (Throwable)e);
        }
    }
}

