/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.config.ConfigWatcher;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnZookeeperEnabled
public class ZookeeperConfigAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RefreshEndpoint.class})
    protected static class ZkRefreshConfiguration {
        protected ZkRefreshConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.zookeeper.config.watcher.enabled"}, matchIfMissing=true)
        public ConfigWatcher configWatcher(ZookeeperPropertySourceLocator locator, CuratorFramework curator) {
            return new ConfigWatcher(locator.getContexts(), curator);
        }
    }
}

