/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.vault.generic")
@Validated
public class VaultGenericBackendProperties
implements EnvironmentAware,
VaultKeyValueBackendPropertiesSupport {
    private boolean enabled = true;
    @NotEmpty
    private String backend = "secret";
    @NotEmpty
    private String defaultContext = "application";
    @NotEmpty
    private String profileSeparator = "/";
    private String applicationName = "application";

    public void setEnvironment(Environment environment) {
        String springCloudVaultAppName = environment.getProperty("spring.cloud.vault.application-name");
        if (StringUtils.hasText((String)springCloudVaultAppName)) {
            this.applicationName = springCloudVaultAppName;
        } else {
            String springAppName = environment.getProperty("spring.application.name");
            if (StringUtils.hasText((String)springAppName)) {
                this.applicationName = springAppName;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getBackend() {
        return this.backend;
    }

    @Override
    public String getDefaultContext() {
        return this.defaultContext;
    }

    @Override
    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [enabled=").append(this.enabled);
        sb.append(", backend='").append(this.backend).append('\'');
        sb.append(", defaultContext='").append(this.defaultContext).append('\'');
        sb.append(", profileSeparator='").append(this.profileSeparator).append('\'');
        sb.append(", applicationName='").append(this.applicationName).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

