/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.ClientAuthenticationFactory;
import org.springframework.cloud.vault.config.VaultConfigurationUtil;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.RestTemplateCustomizer;
import org.springframework.vault.client.RestTemplateRequestCustomizer;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFFA)
public class VaultBootstrapConfiguration
implements InitializingBean {
    private final ConfigurableApplicationContext applicationContext;
    private final VaultProperties vaultProperties;
    private final VaultEndpointProvider endpointProvider;
    private final List<RestTemplateCustomizer> customizers;
    private final List<RestTemplateRequestCustomizer<?>> requestCustomizers;
    private RestTemplateBuilder restTemplateBuilder;
    private RestOperations externalRestOperations;

    public VaultBootstrapConfiguration(ConfigurableApplicationContext applicationContext, VaultProperties vaultProperties, ObjectProvider<VaultEndpointProvider> endpointProvider, ObjectProvider<List<RestTemplateCustomizer>> customizers, ObjectProvider<List<RestTemplateRequestCustomizer<?>>> requestCustomizers) {
        this.applicationContext = applicationContext;
        this.vaultProperties = vaultProperties;
        VaultEndpointProvider provider = (VaultEndpointProvider)endpointProvider.getIfAvailable();
        if (provider == null) {
            provider = SimpleVaultEndpointProvider.of((VaultEndpoint)VaultConfigurationUtil.createVaultEndpoint(vaultProperties));
        }
        this.endpointProvider = provider;
        this.customizers = new ArrayList<RestTemplateCustomizer>((Collection)customizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(this.customizers);
        this.requestCustomizers = new ArrayList((Collection)requestCustomizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(this.requestCustomizers);
    }

    public void afterPropertiesSet() {
        ClientHttpRequestFactory clientHttpRequestFactory = this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory();
        this.restTemplateBuilder = RestTemplateBuilder.builder().requestFactory(clientHttpRequestFactory).endpointProvider(this.endpointProvider);
        this.customizers.forEach(xva$0 -> this.restTemplateBuilder.customizers(new RestTemplateCustomizer[]{xva$0}));
        this.requestCustomizers.forEach(xva$0 -> this.restTemplateBuilder.requestCustomizers(new RestTemplateRequestCustomizer[]{xva$0}));
        if (StringUtils.hasText((String)this.vaultProperties.getNamespace())) {
            this.restTemplateBuilder.defaultHeader("X-Vault-Namespace", this.vaultProperties.getNamespace());
        }
        this.externalRestOperations = new RestTemplate(clientHttpRequestFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public AbstractVaultConfiguration.ClientFactoryWrapper clientHttpRequestFactoryWrapper() {
        ClientOptions clientOptions = new ClientOptions(Duration.ofMillis(this.vaultProperties.getConnectionTimeout()), Duration.ofMillis(this.vaultProperties.getReadTimeout()));
        SslConfiguration sslConfiguration = VaultConfigurationUtil.createSslConfiguration(this.vaultProperties.getSsl());
        return new AbstractVaultConfiguration.ClientFactoryWrapper(ClientHttpRequestFactoryFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration));
    }

    @Bean
    @ConditionalOnMissingBean(value={VaultOperations.class})
    public VaultTemplate vaultTemplate(SessionManager sessionManager) {
        return new VaultTemplate(this.restTemplateBuilder, sessionManager);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={TaskSchedulerWrapper.class})
    public TaskSchedulerWrapper vaultTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(2);
        threadPoolTaskScheduler.setDaemon(true);
        threadPoolTaskScheduler.setThreadNamePrefix("Spring-Cloud-Vault-");
        this.applicationContext.registerShutdownHook();
        return new TaskSchedulerWrapper(threadPoolTaskScheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionManager vaultSessionManager(ClientAuthentication clientAuthentication, ObjectFactory<TaskSchedulerWrapper> asyncTaskExecutorFactory) {
        if (this.vaultProperties.getConfig().getLifecycle().isEnabled()) {
            RestTemplate restTemplate = this.restTemplateBuilder.build();
            return new LifecycleAwareSessionManager(clientAuthentication, (TaskScheduler)((TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), (RestOperations)restTemplate);
        }
        return new SimpleSessionManager(clientAuthentication);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientAuthentication clientAuthentication() {
        RestTemplate restTemplate = this.restTemplateBuilder.build();
        ClientAuthenticationFactory factory = new ClientAuthenticationFactory(this.vaultProperties, (RestOperations)restTemplate, this.externalRestOperations);
        return factory.createClientAuthentication();
    }

    public static class TaskSchedulerWrapper
    implements InitializingBean,
    DisposableBean {
        private final ThreadPoolTaskScheduler taskScheduler;

        public TaskSchedulerWrapper(ThreadPoolTaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
        }

        ThreadPoolTaskScheduler getTaskScheduler() {
            return this.taskScheduler;
        }

        public void destroy() throws Exception {
            this.taskScheduler.destroy();
        }

        public void afterPropertiesSet() throws Exception {
            this.taskScheduler.afterPropertiesSet();
        }
    }
}

