/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.vault.config.VaultHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.core.VaultOperations;

@Configuration
@ConditionalOnBean(value={VaultOperations.class})
class VaultHealthIndicatorConfiguration
extends CompositeHealthIndicatorConfiguration<VaultHealthIndicator, VaultOperations> {
    private final Map<String, VaultOperations> vaultTemplates;

    public VaultHealthIndicatorConfiguration(Map<String, VaultOperations> vaultTemplates) {
        this.vaultTemplates = vaultTemplates;
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultHealthIndicator"})
    public HealthIndicator vaultHealthIndicator() {
        return this.createHealthIndicator(this.vaultTemplates);
    }
}

