/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.core.VaultOperations;

@Configuration
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={VaultBootstrapConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="vault")
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
public class VaultHealthIndicatorConfiguration
extends CompositeHealthIndicatorConfiguration<VaultHealthIndicator, VaultOperations> {
    private final Map<String, VaultOperations> vaultTemplates;

    public VaultHealthIndicatorConfiguration(Map<String, VaultOperations> vaultTemplates) {
        this.vaultTemplates = vaultTemplates;
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultHealthIndicator"})
    public HealthIndicator vaultHealthIndicator() {
        return this.createHealthIndicator(this.vaultTemplates);
    }
}

