/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.vault.config.LeasingSecretBackendMetadata;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendConfigurer;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataWrapper;
import org.springframework.util.Assert;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;

class DefaultSecretBackendConfigurer
implements SecretBackendConfigurer,
PropertySourceLocatorConfiguration {
    private final Map<String, SecretBackendMetadata> secretBackends = new LinkedHashMap<String, SecretBackendMetadata>();
    private boolean registerDefaultGenericSecretBackends = false;
    private boolean registerDefaultDiscoveredSecretBackends = false;

    DefaultSecretBackendConfigurer() {
    }

    @Override
    public SecretBackendConfigurer add(String path) {
        Assert.hasLength((String)path, (String)"Path must not be empty");
        return this.add(path, PropertyTransformers.noop());
    }

    @Override
    public SecretBackendConfigurer add(String path, PropertyTransformer propertyTransformer) {
        Assert.hasLength((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)propertyTransformer, (String)"PropertyTransformer must not be null");
        return this.add(this.createMetadata(path, propertyTransformer));
    }

    private SimpleSecretBackendMetadata createMetadata(String path, PropertyTransformer propertyTransformer) {
        return new SimpleSecretBackendMetadata(path, propertyTransformer);
    }

    @Override
    public SecretBackendConfigurer add(SecretBackendMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"SecretBackendMetadata must not be null");
        this.secretBackends.put(metadata.getPath(), metadata);
        return this;
    }

    @Override
    public SecretBackendConfigurer add(RequestedSecret requestedSecret) {
        Assert.notNull((Object)requestedSecret, (String)"RequestedSecret must not be null");
        return this.add(requestedSecret, PropertyTransformers.noop());
    }

    @Override
    public SecretBackendConfigurer add(RequestedSecret requestedSecret, PropertyTransformer propertyTransformer) {
        Assert.notNull((Object)requestedSecret, (String)"RequestedSecret must not be null");
        Assert.notNull((Object)propertyTransformer, (String)"PropertyTransformer must not be null");
        this.secretBackends.put(requestedSecret.getPath(), new SimpleLeasingSecretBackendMetadata(this.createMetadata(requestedSecret.getPath(), propertyTransformer), requestedSecret.getMode()));
        return this;
    }

    @Override
    public SecretBackendConfigurer registerDefaultGenericSecretBackends(boolean registerDefault) {
        this.registerDefaultGenericSecretBackends = registerDefault;
        return this;
    }

    @Override
    public SecretBackendConfigurer registerDefaultDiscoveredSecretBackends(boolean registerDefault) {
        this.registerDefaultDiscoveredSecretBackends = registerDefault;
        return this;
    }

    public boolean isRegisterDefaultGenericSecretBackends() {
        return this.registerDefaultGenericSecretBackends;
    }

    public boolean isRegisterDefaultDiscoveredSecretBackends() {
        return this.registerDefaultDiscoveredSecretBackends;
    }

    public List<SecretBackendMetadata> getSecretBackends() {
        return new ArrayList<SecretBackendMetadata>(this.secretBackends.values());
    }

    private static class SimpleLeasingSecretBackendMetadata
    extends SecretBackendMetadataWrapper
    implements LeasingSecretBackendMetadata {
        private final RequestedSecret.Mode mode;

        SimpleLeasingSecretBackendMetadata(SecretBackendMetadata delegate, RequestedSecret.Mode mode) {
            super(delegate);
            this.mode = mode;
        }

        @Override
        public RequestedSecret.Mode getLeaseMode() {
            return this.mode;
        }
    }

    private static class SimpleSecretBackendMetadata
    implements SecretBackendMetadata {
        private final String path;
        private final PropertyTransformer propertyTransformer;

        @Override
        public String getName() {
            return String.format("Context backend: %s", this.path);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public PropertyTransformer getPropertyTransformer() {
            return this.propertyTransformer;
        }

        @Override
        public Map<String, String> getVariables() {
            return Collections.singletonMap("path", this.path);
        }

        @ConstructorProperties(value={"path", "propertyTransformer"})
        public SimpleSecretBackendMetadata(String path, PropertyTransformer propertyTransformer) {
            this.path = path;
            this.propertyTransformer = propertyTransformer;
        }
    }
}

