/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.test;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.springframework.cloud.test.ClassPathExclusions;
import org.springframework.cloud.test.ClassPathOverrides;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class ModifiedClassPathClassLoader
extends URLClassLoader {
    private static final Map<List<AnnotatedElement>, ModifiedClassPathClassLoader> cache = new ConcurrentReferenceHashMap();
    private static final Pattern INTELLIJ_CLASSPATH_JAR_PATTERN = Pattern.compile(".*classpath(\\d+)?\\.jar");
    private static final int MAX_RESOLUTION_ATTEMPTS = 5;
    private final ClassLoader junitLoader;

    ModifiedClassPathClassLoader(URL[] urls, ClassLoader parent, ClassLoader junitLoader) {
        super(urls, parent);
        this.junitLoader = junitLoader;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.junit") || name.startsWith("org.hamcrest") || name.startsWith("io.netty.internal.tcnative")) {
            return Class.forName(name, false, this.junitLoader);
        }
        return super.loadClass(name);
    }

    static ModifiedClassPathClassLoader get(Class<?> testClass, Method testMethod, List<Object> arguments) {
        LinkedHashSet<AnnotatedElement> candidates = new LinkedHashSet<AnnotatedElement>();
        candidates.add(testClass);
        candidates.add(testMethod);
        candidates.addAll(ModifiedClassPathClassLoader.getAnnotatedElements(arguments.toArray()));
        List annotatedElements = candidates.stream().filter(ModifiedClassPathClassLoader::hasAnnotation).collect(Collectors.toList());
        if (annotatedElements.isEmpty()) {
            return null;
        }
        return cache.computeIfAbsent(annotatedElements, key -> ModifiedClassPathClassLoader.compute(testClass.getClassLoader(), key));
    }

    private static Collection<AnnotatedElement> getAnnotatedElements(Object[] array) {
        LinkedHashSet<AnnotatedElement> result = new LinkedHashSet<AnnotatedElement>();
        for (Object item : array) {
            if (item instanceof AnnotatedElement) {
                result.add((AnnotatedElement)item);
                continue;
            }
            if (!ObjectUtils.isArray((Object)item)) continue;
            result.addAll(ModifiedClassPathClassLoader.getAnnotatedElements(ObjectUtils.toObjectArray((Object)item)));
        }
        return result;
    }

    private static boolean hasAnnotation(AnnotatedElement element) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        return annotations.isPresent(ClassPathOverrides.class) || annotations.isPresent(ClassPathExclusions.class);
    }

    private static ModifiedClassPathClassLoader compute(ClassLoader classLoader, List<AnnotatedElement> annotatedClasses) {
        List<MergedAnnotations> annotations = annotatedClasses.stream().map(source -> MergedAnnotations.from((AnnotatedElement)source, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY)).toList();
        return new ModifiedClassPathClassLoader(ModifiedClassPathClassLoader.processUrls(ModifiedClassPathClassLoader.extractUrls(classLoader), annotations), classLoader.getParent(), classLoader);
    }

    private static URL[] extractUrls(ClassLoader classLoader) {
        ArrayList extractedUrls = new ArrayList();
        ModifiedClassPathClassLoader.doExtractUrls(classLoader).forEach(url -> {
            if (ModifiedClassPathClassLoader.isManifestOnlyJar(url)) {
                extractedUrls.addAll(ModifiedClassPathClassLoader.extractUrlsFromManifestClassPath(url));
            } else {
                extractedUrls.add(url);
            }
        });
        return extractedUrls.toArray(new URL[0]);
    }

    private static Stream<URL> doExtractUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            return Stream.of(urlClassLoader.getURLs());
        }
        return Stream.of(ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)).map(ModifiedClassPathClassLoader::toURL);
    }

    private static URL toURL(String entry) {
        try {
            return new File(entry).toURI().toURL();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean isManifestOnlyJar(URL url) {
        return ModifiedClassPathClassLoader.isShortenedIntelliJJar(url);
    }

    private static boolean isShortenedIntelliJJar(URL url) {
        String urlPath = url.getPath();
        boolean isCandidate = INTELLIJ_CLASSPATH_JAR_PATTERN.matcher(urlPath).matches();
        if (isCandidate) {
            try {
                Attributes attributes = ModifiedClassPathClassLoader.getManifestMainAttributesFromUrl(url);
                String createdBy = attributes.getValue("Created-By");
                return createdBy != null && createdBy.contains("IntelliJ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static List<URL> extractUrlsFromManifestClassPath(URL booterJar) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String entry : ModifiedClassPathClassLoader.getClassPath(booterJar)) {
                urls.add(new URL(entry));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return urls;
    }

    private static String[] getClassPath(URL booterJar) throws Exception {
        Attributes attributes = ModifiedClassPathClassLoader.getManifestMainAttributesFromUrl(booterJar);
        return StringUtils.delimitedListToStringArray((String)attributes.getValue(Attributes.Name.CLASS_PATH), (String)" ");
    }

    private static Attributes getManifestMainAttributesFromUrl(URL url) throws Exception {
        try (JarFile jarFile = new JarFile(new File(url.toURI()));){
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            return attributes;
        }
    }

    private static URL[] processUrls(URL[] urls, List<MergedAnnotations> annotations) {
        ClassPathEntryFilter filter = new ClassPathEntryFilter(annotations);
        List<URL> additionalUrls = ModifiedClassPathClassLoader.getAdditionalUrls(annotations);
        ArrayList<URL> processedUrls = new ArrayList<URL>(additionalUrls);
        for (URL url : urls) {
            if (filter.isExcluded(url)) continue;
            processedUrls.add(url);
        }
        return processedUrls.toArray(new URL[0]);
    }

    private static List<URL> getAdditionalUrls(List<MergedAnnotations> annotations) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (MergedAnnotations candidate : annotations) {
            MergedAnnotation annotation = candidate.get(ClassPathOverrides.class);
            if (!annotation.isPresent()) continue;
            urls.addAll(ModifiedClassPathClassLoader.resolveCoordinates(annotation.getStringArray("value")));
        }
        return urls.stream().toList();
    }

    private static List<URL> resolveCoordinates(String[] coordinates) {
        Exception latestFailure = null;
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(System.getProperty("user.home") + "/.m2/repository");
        RemoteRepository remoteRepository = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").build();
        session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        for (int i = 0; i < 5; ++i) {
            CollectRequest collectRequest = new CollectRequest(null, Arrays.asList(remoteRepository));
            collectRequest.setDependencies(ModifiedClassPathClassLoader.createDependencies(coordinates));
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            try {
                DependencyResult result = repositorySystem.resolveDependencies((RepositorySystemSession)session, dependencyRequest);
                ArrayList<URL> resolvedArtifacts = new ArrayList<URL>();
                for (ArtifactResult artifact : result.getArtifactResults()) {
                    resolvedArtifacts.add(artifact.getArtifact().getFile().toURI().toURL());
                }
                return resolvedArtifacts;
            }
            catch (Exception ex) {
                latestFailure = ex;
                continue;
            }
        }
        throw new IllegalStateException("Resolution failed after 5 attempts", latestFailure);
    }

    private static List<Dependency> createDependencies(String[] allCoordinates) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String coordinate : allCoordinates) {
            dependencies.add(new Dependency((Artifact)new DefaultArtifact(coordinate), null));
        }
        return dependencies;
    }

    private static final class ClassPathEntryFilter {
        private final List<String> exclusions;
        private final AntPathMatcher matcher = new AntPathMatcher();

        private ClassPathEntryFilter(List<MergedAnnotations> annotations) {
            LinkedHashSet<String> exclusions = new LinkedHashSet<String>();
            for (MergedAnnotations candidate : annotations) {
                MergedAnnotation annotation = candidate.get(ClassPathExclusions.class);
                if (!annotation.isPresent()) continue;
                exclusions.addAll(Arrays.asList(annotation.getStringArray("value")));
            }
            this.exclusions = exclusions.stream().toList();
        }

        private boolean isExcluded(URL url) {
            if ("file".equals(url.getProtocol())) {
                try {
                    String name = new File(url.toURI()).getName();
                    for (String exclusion : this.exclusions) {
                        if (!this.matcher.match(exclusion, name)) continue;
                        return true;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

