/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.test;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.springframework.cloud.test.ClassPathExclusions;
import org.springframework.cloud.test.ClassPathOverrides;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class ModifiedClassPathRunner
extends BlockJUnit4ClassRunner {
    private static final Pattern INTELLIJ_CLASSPATH_JAR_PATTERN = Pattern.compile(".*classpath(\\d+)?\\.jar");

    public ModifiedClassPathRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected TestClass createTestClass(Class<?> testClass) {
        try {
            URLClassLoader classLoader = this.createTestClassLoader(testClass);
            return new ModifiedClassPathTestClass(classLoader, testClass.getName());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected Object createTest() throws Exception {
        ModifiedClassPathTestClass testClass = (ModifiedClassPathTestClass)this.getTestClass();
        return testClass.doWithModifiedClassPathThreadContextClassLoader(() -> ModifiedClassPathRunner.super.createTest());
    }

    private URLClassLoader createTestClassLoader(Class<?> testClass) throws Exception {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        return new ModifiedClassPathClassLoader(this.processUrls(this.extractUrls(classLoader), testClass), classLoader.getParent(), classLoader);
    }

    private URL[] extractUrls(ClassLoader classLoader) throws Exception {
        ArrayList extractedUrls = new ArrayList();
        this.doExtractUrls(classLoader).forEach(url -> {
            if (this.isManifestOnlyJar((URL)url)) {
                extractedUrls.addAll(this.extractUrlsFromManifestClassPath((URL)url));
            } else {
                extractedUrls.add(url);
            }
        });
        return extractedUrls.toArray(new URL[0]);
    }

    private Stream<URL> doExtractUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return Stream.of(((URLClassLoader)classLoader).getURLs());
        }
        return Stream.of(ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)).map(this::toURL);
    }

    private URL toURL(String entry) {
        try {
            return new File(entry).toURI().toURL();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private boolean isManifestOnlyJar(URL url) {
        return this.isSurefireBooterJar(url) || this.isShortenedIntelliJJar(url);
    }

    private boolean isSurefireBooterJar(URL url) {
        return url.getPath().contains("surefirebooter");
    }

    private boolean isShortenedIntelliJJar(URL url) {
        String urlPath = url.getPath();
        boolean isCandidate = INTELLIJ_CLASSPATH_JAR_PATTERN.matcher(urlPath).matches();
        if (isCandidate) {
            try {
                Attributes attributes = this.getManifestMainAttributesFromUrl(url);
                String createdBy = attributes.getValue("Created-By");
                return createdBy != null && createdBy.contains("IntelliJ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private List<URL> extractUrlsFromManifestClassPath(URL booterJar) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String entry : this.getClassPath(booterJar)) {
                urls.add(new URL(entry));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return urls;
    }

    private String[] getClassPath(URL booterJar) throws Exception {
        Attributes attributes = this.getManifestMainAttributesFromUrl(booterJar);
        return StringUtils.delimitedListToStringArray((String)attributes.getValue(Attributes.Name.CLASS_PATH), (String)" ");
    }

    private Attributes getManifestMainAttributesFromUrl(URL url) throws Exception {
        try (JarFile jarFile = new JarFile(new File(url.toURI()));){
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            return attributes;
        }
    }

    private URL[] processUrls(URL[] urls, Class<?> testClass) throws Exception {
        MergedAnnotations annotations = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        ClassPathEntryFilter filter = new ClassPathEntryFilter((MergedAnnotation<ClassPathExclusions>)annotations.get(ClassPathExclusions.class));
        List<URL> additionalUrls = this.getAdditionalUrls((MergedAnnotation<ClassPathOverrides>)annotations.get(ClassPathOverrides.class));
        ArrayList<URL> processedUrls = new ArrayList<URL>(additionalUrls);
        for (URL url : urls) {
            if (filter.isExcluded(url)) continue;
            processedUrls.add(url);
        }
        return processedUrls.toArray(new URL[0]);
    }

    private List<URL> getAdditionalUrls(MergedAnnotation<ClassPathOverrides> annotation) throws Exception {
        if (!annotation.isPresent()) {
            return Collections.emptyList();
        }
        return this.resolveCoordinates(annotation.getStringArray("value"));
    }

    private List<URL> resolveCoordinates(String[] coordinates) throws Exception {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(System.getProperty("user.home") + "/.m2/repository");
        session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        CollectRequest collectRequest = new CollectRequest(null, Collections.singletonList(new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").build()));
        collectRequest.setDependencies(this.createDependencies(coordinates));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        DependencyResult result = repositorySystem.resolveDependencies((RepositorySystemSession)session, dependencyRequest);
        ArrayList<URL> resolvedArtifacts = new ArrayList<URL>();
        for (ArtifactResult artifact : result.getArtifactResults()) {
            resolvedArtifacts.add(artifact.getArtifact().getFile().toURI().toURL());
        }
        return resolvedArtifacts;
    }

    private List<Dependency> createDependencies(String[] allCoordinates) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String coordinate : allCoordinates) {
            dependencies.add(new Dependency((Artifact)new DefaultArtifact(coordinate), null));
        }
        return dependencies;
    }

    private static final class ModifiedClassPathTestClass
    extends TestClass {
        private final ClassLoader classLoader;

        ModifiedClassPathTestClass(ClassLoader classLoader, String testClassName) throws ClassNotFoundException {
            super(classLoader.loadClass(testClassName));
            this.classLoader = classLoader;
        }

        public List<FrameworkMethod> getAnnotatedMethods(Class<? extends Annotation> annotationClass) {
            try {
                return this.getAnnotatedMethods(annotationClass.getName());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List<FrameworkMethod> getAnnotatedMethods(String annotationClassName) throws ClassNotFoundException {
            Class<?> annotationClass = this.classLoader.loadClass(annotationClassName);
            List methods = super.getAnnotatedMethods(annotationClass);
            return this.wrapFrameworkMethods(methods);
        }

        private List<FrameworkMethod> wrapFrameworkMethods(List<FrameworkMethod> methods) {
            ArrayList<FrameworkMethod> wrapped = new ArrayList<FrameworkMethod>(methods.size());
            for (FrameworkMethod frameworkMethod : methods) {
                wrapped.add(new ModifiedClassPathFrameworkMethod(frameworkMethod.getMethod()));
            }
            return wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T, E extends Throwable> T doWithModifiedClassPathThreadContextClassLoader(ModifiedClassPathTcclAction<T, E> action) throws E {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                T t = action.perform();
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }

        private final class ModifiedClassPathFrameworkMethod
        extends FrameworkMethod {
            private ModifiedClassPathFrameworkMethod(Method method) {
                super(method);
            }

            public Object invokeExplosively(Object target, Object ... params) throws Throwable {
                return ModifiedClassPathTestClass.this.doWithModifiedClassPathThreadContextClassLoader(() -> ModifiedClassPathFrameworkMethod.super.invokeExplosively(target, params));
            }
        }

        private static interface ModifiedClassPathTcclAction<T, E extends Throwable> {
            public T perform() throws E;
        }
    }

    private static final class ModifiedClassPathClassLoader
    extends URLClassLoader {
        private final ClassLoader junitLoader;

        ModifiedClassPathClassLoader(URL[] urls, ClassLoader parent, ClassLoader junitLoader) {
            super(urls, parent);
            this.junitLoader = junitLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith("org.junit") || name.startsWith("org.hamcrest")) {
                return this.junitLoader.loadClass(name);
            }
            return super.loadClass(name);
        }
    }

    private static final class ClassPathEntryFilter {
        private final List<String> exclusions;
        private final AntPathMatcher matcher = new AntPathMatcher();

        private ClassPathEntryFilter(MergedAnnotation<ClassPathExclusions> annotation) {
            this.exclusions = new ArrayList<String>();
            this.exclusions.add("log4j-*.jar");
            if (annotation.isPresent()) {
                this.exclusions.addAll(Arrays.asList(annotation.getStringArray("value")));
            }
        }

        private boolean isExcluded(URL url) throws Exception {
            if (!"file".equals(url.getProtocol())) {
                return false;
            }
            String name = new File(url.toURI()).getName();
            for (String exclusion : this.exclusions) {
                if (!this.matcher.match(exclusion, name)) continue;
                return true;
            }
            return false;
        }
    }
}

