/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.cloud.task.configuration.SimpleTaskAutoConfiguration;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@ConditionalOnClass(value={StreamBridge.class})
@ConditionalOnBean(value={TaskLifecycleListener.class})
@ConditionalOnExpression(value="T(org.springframework.util.StringUtils).isEmpty('${spring.batch.job.jobName:}')")
@ConditionalOnProperty(prefix="spring.cloud.task.events", name={"enabled"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:/org/springframework/cloud/task/application.properties"})
@AutoConfigureBefore(value={BindingServiceConfiguration.class})
@AutoConfigureAfter(value={SimpleTaskAutoConfiguration.class})
@EnableConfigurationProperties(value={TaskEventProperties.class})
public class TaskEventAutoConfiguration {

    @AutoConfiguration
    public static class ListenerConfiguration {
        @Bean
        public TaskExecutionListener taskEventEmitter(final StreamBridge streamBridge, final TaskEventProperties taskEventProperties) {
            return new TaskExecutionListener(){

                public void onTaskStartup(TaskExecution taskExecution) {
                    streamBridge.send(taskEventProperties.getTaskEventBindingName(), (Object)taskExecution);
                }

                public void onTaskEnd(TaskExecution taskExecution) {
                    streamBridge.send(taskEventProperties.getTaskEventBindingName(), (Object)taskExecution);
                }

                public void onTaskFailed(TaskExecution taskExecution, Throwable throwable) {
                    streamBridge.send(taskEventProperties.getTaskEventBindingName(), (Object)taskExecution);
                }
            };
        }
    }
}

