/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.core.Ordered;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingChunkListener
implements ChunkListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingChunkListener.class);
    private MessagePublisher<String> messagePublisher;
    private int order = Integer.MAX_VALUE;

    public EventEmittingChunkListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public EventEmittingChunkListener(MessageChannel output, int order) {
        this(output);
        this.order = order;
    }

    public void beforeChunk(ChunkContext context) {
        this.messagePublisher.publish("Before Chunk Processing");
    }

    public void afterChunk(ChunkContext context) {
        this.messagePublisher.publish("After Chunk Processing");
    }

    public void afterChunkError(ChunkContext context) {
    }

    public int getOrder() {
        return this.order;
    }
}

