/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.AbstractBindingLifecycle;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.cloud.stream.function.BindableFunctionProxyFactory;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

public class BindingsLifecycleController
implements ApplicationContextAware {
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final List<OutputBindingLifecycle> outputBindingsLifecycles;
    private final ObjectMapper objectMapper;
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingsLifecycleController(List<InputBindingLifecycle> inputBindingLifecycles, List<OutputBindingLifecycle> outputBindingsLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.outputBindingsLifecycles = outputBindingsLifecycles;
        JsonMapper.Builder builder = JsonMapper.builder();
        try {
            Class javaTimeModuleClass = ClassUtils.forName((String)"tools.jackson.datatype.jsr310.JavaTimeModule", (ClassLoader)ClassUtils.getDefaultClassLoader());
            JacksonModule javaTimeModule = (JacksonModule)BeanUtils.instantiateClass((Class)javaTimeModuleClass);
            builder.addModule(javaTimeModule);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            this.objectMapper = builder.build();
        }
    }

    public <P> P defineInputBinding(String bindingName) {
        BindableFunctionProxyFactory bindingProxyFactory = new BindableFunctionProxyFactory(bindingName, 1, 0, (StreamFunctionProperties)this.applicationContext.getBean(StreamFunctionProperties.class), false);
        this.defineBinding(bindingProxyFactory);
        return (P)this.getExtensionProperties(bindingName);
    }

    public <P> P defineOutputBinding(String bindingName) {
        BindableFunctionProxyFactory bindingProxyFactory = new BindableFunctionProxyFactory(bindingName, 0, 1, (StreamFunctionProperties)this.applicationContext.getBean(StreamFunctionProperties.class), false);
        this.defineBinding(bindingProxyFactory);
        return (P)this.getExtensionProperties(bindingName);
    }

    public <T> T getExtensionProperties(String bindingName) {
        List<Binding<?>> locateBinding = this.locateBinding(bindingName);
        if (!CollectionUtils.isEmpty(locateBinding)) {
            return (T)locateBinding.get(0).getExtension();
        }
        return null;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void stop(String bindingName) {
        this.changeState(bindingName, State.STOPPED);
    }

    public void start(String bindingName) {
        this.changeState(bindingName, State.STARTED);
    }

    public void pause(String bindingName) {
        this.changeState(bindingName, State.PAUSED);
    }

    public void resume(String bindingName) {
        this.changeState(bindingName, State.RESUMED);
    }

    public void changeState(String bindingName, State state) {
        List<Binding<?>> bindingList = this.locateBinding(bindingName);
        if (!bindingList.isEmpty()) {
            switch (state.ordinal()) {
                case 0: {
                    bindingList.stream().forEach(Binding::start);
                    break;
                }
                case 1: {
                    bindingList.stream().forEach(Binding::stop);
                    break;
                }
                case 2: {
                    bindingList.stream().forEach(Binding::pause);
                    break;
                }
                case 3: {
                    bindingList.stream().forEach(Binding::resume);
                    break;
                }
            }
        }
    }

    public List<Map<String, Object>> queryStates() {
        ArrayList bindings = new ArrayList(this.gatherInputBindings());
        bindings.addAll(this.gatherOutputBindings());
        return (List)this.objectMapper.convertValue(bindings, List.class);
    }

    public List<Binding<?>> queryState(String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return this.locateBinding(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void defineBinding(BindableFunctionProxyFactory bindingProxyFactory) {
        AbstractBindingLifecycle bindingLifecycle;
        bindingProxyFactory.setApplicationContext(this.applicationContext);
        bindingProxyFactory.afterPropertiesSet();
        BindingService bindingService = (BindingService)this.applicationContext.getBean(BindingService.class);
        if (bindingProxyFactory.getInputs().size() > 0) {
            bindingProxyFactory.createAndBindInputs(bindingService);
            bindingLifecycle = (AbstractBindingLifecycle)this.applicationContext.getBean(InputBindingLifecycle.class);
        } else {
            bindingProxyFactory.createAndBindOutputs(bindingService);
            bindingLifecycle = (AbstractBindingLifecycle)this.applicationContext.getBean(OutputBindingLifecycle.class);
        }
        bindingLifecycle.startBindable(bindingProxyFactory);
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private List<Binding<?>> gatherOutputBindings() {
        ArrayList outputBindings = new ArrayList();
        for (OutputBindingLifecycle inputBindingLifecycle : this.outputBindingsLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("outputBindings");
            outputBindings.addAll(lifecycleInputBindings);
        }
        return outputBindings;
    }

    private List<Binding<?>> locateBinding(String name) {
        Stream bindings = Stream.concat(this.gatherInputBindings().stream(), this.gatherOutputBindings().stream());
        return bindings.filter(binding -> name.equals(binding.getBindingName())).collect(Collectors.toList());
    }

    public static enum State {
        STARTED,
        STOPPED,
        PAUSED,
        RESUMED;

    }
}

