/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.Lifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.Pausable;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@JsonPropertyOrder(value={"bindingName", "name", "group", "pausable", "state"})
@JsonIgnoreProperties(value={"running"})
public class DefaultBinding<T>
implements Binding<T> {
    protected final String name;
    protected final String group;
    protected final T target;
    protected final Lifecycle lifecycle;
    private final Log logger = LogFactory.getLog((String)this.getClass().getName());
    private boolean paused;
    private boolean restartable;
    private Lifecycle companion;

    public DefaultBinding(String name, String group, T target, Lifecycle lifecycle) {
        Assert.notNull(target, (String)"target must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.lifecycle = lifecycle;
        this.restartable = StringUtils.hasText((String)group);
    }

    public DefaultBinding(String name, T target, Lifecycle lifecycle) {
        this(name, null, target, lifecycle);
        this.restartable = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBindingName() {
        String string;
        T t = this.target;
        if (t instanceof IntegrationObjectSupport) {
            IntegrationObjectSupport integrationObjectSupportTarget = (IntegrationObjectSupport)t;
            string = integrationObjectSupportTarget.getComponentName();
        } else {
            string = this.getName();
        }
        String resolvedName = string;
        return resolvedName == null ? this.getName() : resolvedName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getState() {
        String state = "N/A";
        if (this.lifecycle != null) {
            state = this.isPausable() ? (this.paused ? "paused" : this.getRunningState()) : this.getRunningState();
        }
        return state;
    }

    @Override
    public boolean isRunning() {
        return this.lifecycle != null && this.lifecycle.isRunning();
    }

    public boolean isPausable() {
        return this.lifecycle instanceof Pausable;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized void start() {
        if (this.companion != null) {
            this.companion.start();
        }
        if (!this.isRunning()) {
            if (this.lifecycle != null && this.restartable) {
                this.lifecycle.start();
            } else {
                this.logger.warn((Object)"Can not re-bind an anonymous binding");
            }
        }
    }

    @Override
    public synchronized void stop() {
        T t;
        if (this.companion != null) {
            this.companion.stop();
        }
        if (this.isRunning()) {
            this.lifecycle.stop();
        }
        if ((t = this.target) instanceof DirectWithAttributesChannel) {
            DirectWithAttributesChannel attributeChannel = (DirectWithAttributesChannel)((Object)t);
            attributeChannel.destroy();
        }
    }

    @Override
    public synchronized void pause() {
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle instanceof Pausable) {
            Pausable pausableLifecycle = (Pausable)lifecycle;
            pausableLifecycle.pause();
            this.paused = true;
        } else {
            this.logger.warn((Object)("Attempted to pause a component that does not support Pausable " + this.lifecycle));
        }
    }

    @Override
    public synchronized void resume() {
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle instanceof Pausable) {
            Pausable pausableLifecycle = (Pausable)lifecycle;
            pausableLifecycle.resume();
            this.paused = false;
        } else {
            this.logger.warn((Object)("Attempted to resume a component that does not support Pausable " + this.lifecycle));
        }
    }

    @Override
    public void unbind() {
        this.stop();
        this.afterUnbind();
    }

    Lifecycle getEndpoint() {
        return this.lifecycle;
    }

    public String toString() {
        String string;
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle instanceof NamedComponent) {
            NamedComponent namedComponentWithLifeCycle = (NamedComponent)lifecycle;
            string = namedComponentWithLifeCycle.getComponentName();
        } else {
            string = ObjectUtils.nullSafeToString((Object)this.lifecycle);
        }
        return " Binding [name=" + this.name + ", target=" + this.target + ", lifecycle=" + string + "]";
    }

    protected void afterUnbind() {
    }

    private String getRunningState() {
        return this.isRunning() ? "running" : "stopped";
    }

    public void setCompanion(Lifecycle companion) {
        this.companion = companion;
    }
}

