/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.beans.Introspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.integration.expression.SpelPropertyAccessorRegistrar;
import org.springframework.integration.json.JsonPropertyAccessor;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class SpelExpressionConverterConfiguration {
    @Bean
    public static SpelPropertyAccessorRegistrar spelPropertyAccessorRegistrar() {
        return new SpelPropertyAccessorRegistrar().add(Introspector.decapitalize(JsonPropertyAccessor.class.getSimpleName()), (PropertyAccessor)new JsonPropertyAccessor());
    }

    @Bean
    @ConfigurationPropertiesBinding
    @IntegrationConverter
    public Converter<Object, Expression> spelConverter(ConfigurableApplicationContext context) {
        SpelConverter converter = new SpelConverter();
        ConfigurableConversionService cs = (ConfigurableConversionService)context.getBeanFactory().getConversionService();
        if (cs != null) {
            cs.addConverter((Converter)converter);
        }
        return converter;
    }

    public static class SpelConverter
    implements Converter<Object, Expression> {
        private SpelExpressionParser parser = new SpelExpressionParser();
        @Autowired
        @Qualifier(value="integrationEvaluationContext")
        @Lazy
        private EvaluationContext evaluationContext;

        public Expression convert(Object source) {
            try {
                Expression expression;
                if (!(source instanceof String)) {
                    source = String.valueOf(source);
                }
                if ((expression = this.parser.parseExpression((String)source)) instanceof SpelExpression) {
                    ((SpelExpression)expression).setEvaluationContext(this.evaluationContext);
                }
                return expression;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Could not convert '%s' into a SpEL expression", source), e);
            }
        }
    }
}

