/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.converter.ApplicationJsonMessageMarshallingConverter;
import org.springframework.cloud.stream.converter.ConversionException;
import org.springframework.cloud.stream.converter.ObjectStringMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ReflectionUtils;

public class CompositeMessageConverterFactory {
    private final Log log = LogFactory.getLog(CompositeMessageConverterFactory.class);
    private final ObjectMapper objectMapper;
    private final List<MessageConverter> converters;

    public CompositeMessageConverterFactory() {
        this(Collections.emptyList(), new ObjectMapper());
    }

    public CompositeMessageConverterFactory(List<? extends MessageConverter> customConverters, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.converters = !CollectionUtils.isEmpty(customConverters) ? new ArrayList<MessageConverter>(customConverters) : new ArrayList<MessageConverter>();
        this.initDefaultConverters();
        final Field headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
        headersField.setAccessible(true);
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver(){

            public MimeType resolve(@Nullable MessageHeaders headers) {
                Object contentType = headers.get((Object)"contentType");
                if (contentType instanceof byte[]) {
                    contentType = new String((byte[])contentType, StandardCharsets.UTF_8);
                    contentType = ((String)contentType).replace("\"", "");
                    Map headersMap = (Map)ReflectionUtils.getField((Field)headersField, (Object)headers);
                    headersMap.put("contentType", contentType);
                }
                return super.resolve(headers);
            }
        };
        resolver.setDefaultMimeType(BindingProperties.DEFAULT_CONTENT_TYPE);
        this.converters.stream().filter(mc -> mc instanceof AbstractMessageConverter).forEach(mc -> ((AbstractMessageConverter)mc).setContentTypeResolver((ContentTypeResolver)resolver));
    }

    private void initDefaultConverters() {
        ApplicationJsonMessageMarshallingConverter applicationJsonConverter = new ApplicationJsonMessageMarshallingConverter(this.objectMapper);
        applicationJsonConverter.setStrictContentTypeMatch(true);
        this.converters.add((MessageConverter)applicationJsonConverter);
        this.converters.add((MessageConverter)new ByteArrayMessageConverter(){

            protected boolean supports(Class<?> clazz) {
                if (!super.supports(clazz)) {
                    return Object.class == clazz;
                }
                return true;
            }
        });
        this.converters.add((MessageConverter)new ObjectStringMessageConverter());
    }

    public MessageConverter getMessageConverterForType(MimeType mimeType) {
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        for (MessageConverter converter : this.converters) {
            if (converter instanceof AbstractMessageConverter) {
                for (MimeType type : ((AbstractMessageConverter)converter).getSupportedMimeTypes()) {
                    if (!type.includes(mimeType)) continue;
                    converters.add(converter);
                }
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Ommitted " + converter + " of type " + converter.getClass().toString() + " for '" + mimeType.toString() + "' as it is not an AbstractMessageConverter"));
        }
        if (CollectionUtils.isEmpty(converters)) {
            throw new ConversionException("No message converter is registered for " + mimeType.toString());
        }
        if (converters.size() > 1) {
            return new CompositeMessageConverter(converters);
        }
        return (MessageConverter)converters.get(0);
    }

    public CompositeMessageConverter getMessageConverterForAllRegistered() {
        return new CompositeMessageConverter(new ArrayList<MessageConverter>(this.converters));
    }
}

