/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.PartitionAwareFunctionWrapper;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.config.GlobalChannelInterceptorProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public final class StreamBridge
implements SmartInitializingSingleton {
    private static String STREAM_BRIDGE_FUNC_NAME = "streamBridge";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, SubscribableChannel> channelCache;
    private final FunctionCatalog functionCatalog;
    private final FunctionRegistry functionRegistry;
    private final BinderAwareChannelResolver.NewDestinationBindingCallback destinationBindingCallback;
    private BindingServiceProperties bindingServiceProperties;
    private ConfigurableApplicationContext applicationContext;
    private boolean initialized;
    private final BindingService bindingService;

    StreamBridge(FunctionCatalog functionCatalog, FunctionRegistry functionRegistry, final BindingServiceProperties bindingServiceProperties, ConfigurableApplicationContext applicationContext, @Nullable BinderAwareChannelResolver.NewDestinationBindingCallback destinationBindingCallback) {
        this.bindingService = (BindingService)applicationContext.getBean(BindingService.class);
        this.functionCatalog = functionCatalog;
        this.functionRegistry = functionRegistry;
        this.applicationContext = applicationContext;
        this.bindingServiceProperties = bindingServiceProperties;
        this.destinationBindingCallback = destinationBindingCallback;
        this.channelCache = new LinkedHashMap<String, SubscribableChannel>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, SubscribableChannel> eldest) {
                boolean remove;
                boolean bl = remove = this.size() > bindingServiceProperties.getDynamicDestinationCacheSize();
                if (remove && StreamBridge.this.logger.isDebugEnabled()) {
                    StreamBridge.this.logger.debug((Object)("Removing message channel from cache " + eldest.getKey()));
                }
                return remove;
            }
        };
    }

    public boolean send(String bindingName, Object data) {
        return this.send(bindingName, data, MimeTypeUtils.APPLICATION_JSON);
    }

    public boolean send(String bindingName, Object data, MimeType outputContentType) {
        return this.send(bindingName, null, data, outputContentType);
    }

    public boolean send(String bindingName, @Nullable String binderName, Object data) {
        return this.send(bindingName, binderName, data, MimeTypeUtils.APPLICATION_JSON);
    }

    public boolean send(String bindingName, @Nullable String binderName, Object data, MimeType outputContentType) {
        if (!(data instanceof Message)) {
            data = MessageBuilder.withPayload((Object)data).build();
        }
        ProducerProperties producerProperties = this.bindingServiceProperties.getProducerProperties(bindingName);
        SubscribableChannel messageChannel = this.resolveDestination(bindingName, producerProperties, binderName);
        Function functionToInvoke = (Function)this.functionCatalog.lookup(STREAM_BRIDGE_FUNC_NAME, new String[]{outputContentType.toString()});
        ((SimpleFunctionRegistry.FunctionInvocationWrapper)functionToInvoke).setSkipOutputConversion(producerProperties.isUseNativeEncoding());
        if (producerProperties != null && producerProperties.isPartitioned()) {
            functionToInvoke = new PartitionAwareFunctionWrapper(functionToInvoke, this.applicationContext, producerProperties);
        }
        if (data instanceof Message) {
            data = MessageBuilder.fromMessage((Message)((Message)data)).setHeader(MessageUtils.TARGET_PROTOCOL, (Object)"streamBridge").build();
        }
        Message resultMessage = (Message)functionToInvoke.apply(data);
        return messageChannel.send(resultMessage);
    }

    public void afterSingletonsInstantiated() {
        if (this.initialized) {
            return;
        }
        FunctionRegistration fr = new FunctionRegistration(v -> v, new String[]{STREAM_BRIDGE_FUNC_NAME});
        this.functionRegistry.register(fr.type(FunctionType.from(Object.class).to(Object.class).message()));
        Map channels = this.applicationContext.getBeansOfType(DirectWithAttributesChannel.class);
        for (Map.Entry channelEntry : channels.entrySet()) {
            if (!((DirectWithAttributesChannel)((Object)channelEntry.getValue())).getAttribute("type").equals("output")) continue;
            this.channelCache.put((String)channelEntry.getKey(), (SubscribableChannel)channelEntry.getValue());
        }
        this.initialized = true;
    }

    synchronized SubscribableChannel resolveDestination(String destinationName, ProducerProperties producerProperties, String binderName) {
        Object messageChannel = this.channelCache.get(destinationName);
        if (messageChannel == null && this.applicationContext.containsBean(destinationName)) {
            messageChannel = (SubscribableChannel)this.applicationContext.getBean(destinationName, SubscribableChannel.class);
            this.addInterceptors((AbstractMessageChannel)messageChannel, destinationName);
        }
        if (messageChannel == null) {
            messageChannel = new DirectWithAttributesChannel();
            if (this.destinationBindingCallback != null) {
                Object extendedProducerProperties = this.bindingService.getExtendedProducerProperties(messageChannel, destinationName);
                this.destinationBindingCallback.configure(destinationName, (MessageChannel)messageChannel, producerProperties, extendedProducerProperties);
            }
            Binder<?, ConsumerProperties, ProducerProperties> binder = null;
            if (StringUtils.hasText((String)binderName)) {
                BinderFactory binderFactory = (BinderFactory)this.applicationContext.getBean(BinderFactory.class);
                binder = binderFactory.getBinder(binderName, messageChannel.getClass());
            }
            this.bindingService.bindProducer(messageChannel, destinationName, false, binder);
            this.channelCache.put(destinationName, (SubscribableChannel)messageChannel);
            this.addInterceptors((AbstractMessageChannel)messageChannel, destinationName);
        }
        return messageChannel;
    }

    private void addInterceptors(AbstractMessageChannel messageChannel, String destinationName) {
        GlobalChannelInterceptorProcessor globalChannelInterceptorProcessor = (GlobalChannelInterceptorProcessor)this.applicationContext.getBean(GlobalChannelInterceptorProcessor.class);
        globalChannelInterceptorProcessor.postProcessAfterInitialization((Object)messageChannel, destinationName);
    }
}

