/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BinderAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final BindingService bindingService;
    private final AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory;
    private final DynamicDestinationsBindable dynamicDestinationsBindable;
    private final NewDestinationBindingCallback newBindingCallback;
    private ConfigurableListableBeanFactory beanFactory;

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable) {
        this(bindingService, bindingTargetFactory, dynamicDestinationsBindable, null);
    }

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, NewDestinationBindingCallback callback) {
        this.dynamicDestinationsBindable = dynamicDestinationsBindable;
        Assert.notNull((Object)bindingService, (String)"'bindingService' cannot be null");
        Assert.notNull(bindingTargetFactory, (String)"'bindingTargetFactory' cannot be null");
        this.bindingService = bindingService;
        this.bindingTargetFactory = bindingTargetFactory;
        this.newBindingCallback = callback;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        Assert.isTrue((boolean)(beanFactory instanceof ConfigurableListableBeanFactory), (String)"'beanFactory' must be an instance of ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public synchronized MessageChannel resolveDestination(String channelName) {
        MessageChannel channel;
        BindingServiceProperties bindingServiceProperties = this.bindingService.getBindingServiceProperties();
        Object[] dynamicDestinations = bindingServiceProperties.getDynamicDestinations();
        boolean dynamicAllowed = ObjectUtils.isEmpty((Object[])dynamicDestinations) || ObjectUtils.containsElement((Object[])dynamicDestinations, (Object)channelName);
        try {
            channel = super.resolveDestination(channelName);
        }
        catch (DestinationResolutionException e) {
            if (!dynamicAllowed) {
                throw e;
            }
            channel = this.bindingTargetFactory.createOutput(channelName);
            this.beanFactory.registerSingleton(channelName, (Object)channel);
            channel = (MessageChannel)this.beanFactory.initializeBean((Object)channel, channelName);
            if (this.newBindingCallback != null) {
                ProducerProperties producerProperties = bindingServiceProperties.getProducerProperties(channelName);
                Object extendedProducerProperties = this.bindingService.getExtendedProducerProperties(channel, channelName);
                this.newBindingCallback.configure(channelName, channel, producerProperties, extendedProducerProperties);
                bindingServiceProperties.updateProducerProperties(channelName, producerProperties);
            }
            Binding<MessageChannel> binding = this.bindingService.bindProducer(channel, channelName);
            this.dynamicDestinationsBindable.addOutputBinding(channelName, binding);
        }
        return channel;
    }

    @FunctionalInterface
    public static interface NewDestinationBindingCallback<T> {
        public void configure(String var1, MessageChannel var2, ProducerProperties var3, T var4);
    }
}

