/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binding.AbstractBindableProxyFactory;
import org.springframework.cloud.stream.binding.BindingBeanDefinitionRegistryUtils;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BindableProxyFactory
extends AbstractBindableProxyFactory
implements MethodInterceptor,
FactoryBean<Object>,
InitializingBean {
    private static Log log = LogFactory.getLog(BindableProxyFactory.class);
    private final Map<Method, Object> targetCache = new HashMap<Method, Object>(2);
    private Object proxy;

    public BindableProxyFactory(Class<?> type) {
        super(type);
        this.type = type;
    }

    public synchronized Object invoke(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Object boundTarget = this.targetCache.get(method);
        if (boundTarget != null) {
            return boundTarget;
        }
        Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
        if (input != null) {
            String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(input, method);
            boundTarget = ((BoundTargetHolder)this.inputHolders.get(name)).getBoundTarget();
            this.targetCache.put(method, boundTarget);
            return boundTarget;
        }
        Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
        if (output != null) {
            String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(output, method);
            boundTarget = ((BoundTargetHolder)this.outputHolders.get(name)).getBoundTarget();
            this.targetCache.put(method, boundTarget);
            return boundTarget;
        }
        return null;
    }

    public void replaceInputChannel(String originalChannelName, String newChannelName, SubscribableChannel messageChannel) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Replacing '" + originalChannelName + "' binding channel with '" + newChannelName + "'"));
        }
        BoundTargetHolder holder = new BoundTargetHolder(messageChannel, true);
        this.inputHolders.remove(originalChannelName);
        this.inputHolders.put(newChannelName, holder);
    }

    public void replaceOutputChannel(String originalChannelName, String newChannelName, MessageChannel messageChannel) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Replacing '" + originalChannelName + "' binding channel with '" + newChannelName + "'"));
        }
        BoundTargetHolder holder = new BoundTargetHolder(messageChannel, true);
        this.outputHolders.remove(originalChannelName);
        this.outputHolders.put(newChannelName, holder);
    }

    public void afterPropertiesSet() {
        Assert.notEmpty((Map)this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        ReflectionUtils.doWithMethods((Class)this.type, method -> {
            Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
            if (input != null) {
                String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(input, method);
                Class<?> returnType = method.getReturnType();
                this.inputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(returnType).createInput(name), true));
            }
        });
        ReflectionUtils.doWithMethods((Class)this.type, method -> {
            Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
            if (output != null) {
                String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(output, method);
                Class<?> returnType = method.getReturnType();
                this.outputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(returnType).createOutput(name), true));
            }
        });
    }

    public synchronized Object getObject() {
        if (this.proxy == null) {
            ProxyFactory factory = new ProxyFactory(this.type, (Interceptor)this);
            this.proxy = factory.getProxy();
        }
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }
}

