/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;

@Endpoint(id="channels")
public class ChannelsEndpoint {
    private List<Bindable> adapters;
    private BindingServiceProperties properties;

    public ChannelsEndpoint(List<Bindable> adapters, BindingServiceProperties properties) {
        this.adapters = adapters;
        this.properties = properties;
    }

    @ReadOperation
    public Map<String, Object> channels() {
        ChannelsMetaData map = new ChannelsMetaData();
        Map<String, BindingProperties> inputs = map.getInputs();
        Map<String, BindingProperties> outputs = map.getOutputs();
        for (Bindable factory : this.adapters) {
            for (String name : factory.getInputs()) {
                inputs.put(name, this.properties.getBindingProperties(name));
            }
            for (String name : factory.getOutputs()) {
                outputs.put(name, this.properties.getBindingProperties(name));
            }
        }
        return (Map)new ObjectMapper().convertValue((Object)map, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class ChannelsMetaData {
        private Map<String, BindingProperties> inputs = new LinkedHashMap<String, BindingProperties>();
        private Map<String, BindingProperties> outputs = new LinkedHashMap<String, BindingProperties>();

        public Map<String, BindingProperties> getInputs() {
            return this.inputs;
        }

        public Map<String, BindingProperties> getOutputs() {
            return this.outputs;
        }
    }
}

