/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.springframework.cloud.stream.binder.BinderHeaders;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ObjectUtils;

public abstract class EmbeddedHeaderUtils {
    private static final Jackson2JsonObjectMapper objectMapper = new Jackson2JsonObjectMapper();

    public static String decodeExceptionMessage(Message<?> requestMessage) {
        return "Could not convert message: " + DatatypeConverter.printHexBinary((byte[])((byte[])requestMessage.getPayload()));
    }

    public static byte[] embedHeaders(MessageValues original, String ... headers) throws Exception {
        byte[][] headerValues = new byte[headers.length][];
        int n = 0;
        int headerCount = 0;
        int headersLength = 0;
        for (String header : headers) {
            Object value = original.get(header);
            if (value != null) {
                String json = objectMapper.toJson(value);
                headerValues[n] = json.getBytes("UTF-8");
                ++headerCount;
                headersLength += header.length() + headerValues[n++].length;
                continue;
            }
            headerValues[n++] = null;
        }
        byte[] newPayload = new byte[((byte[])original.getPayload()).length + headersLength + headerCount * 5 + 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(newPayload);
        byteBuffer.put((byte)-1);
        byteBuffer.put((byte)headerCount);
        for (int i = 0; i < headers.length; ++i) {
            if (headerValues[i] == null) continue;
            byteBuffer.put((byte)headers[i].length());
            byteBuffer.put(headers[i].getBytes("UTF-8"));
            byteBuffer.putInt(headerValues[i].length);
            byteBuffer.put(headerValues[i]);
        }
        byteBuffer.put((byte[])original.getPayload());
        return byteBuffer.array();
    }

    public static MessageValues extractHeaders(Message<byte[]> message, boolean copyRequestHeaders) throws Exception {
        return EmbeddedHeaderUtils.extractHeaders((byte[])message.getPayload(), copyRequestHeaders, message.getHeaders());
    }

    private static MessageValues extractHeaders(byte[] payload, boolean copyRequestHeaders, MessageHeaders requestHeaders) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        int headerCount = byteBuffer.get() & 0xFF;
        if (headerCount == 255) {
            headerCount = byteBuffer.get() & 0xFF;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            for (int i = 0; i < headerCount; ++i) {
                int len = byteBuffer.get() & 0xFF;
                String headerName = new String(payload, byteBuffer.position(), len, "UTF-8");
                byteBuffer.position(byteBuffer.position() + len);
                len = byteBuffer.getInt();
                String headerValue = new String(payload, byteBuffer.position(), len, "UTF-8");
                Object headerContent = objectMapper.fromJson((Object)headerValue, Object.class);
                headers.put(headerName, headerContent);
                byteBuffer.position(byteBuffer.position() + len);
            }
            byte[] newPayload = new byte[byteBuffer.remaining()];
            byteBuffer.get(newPayload);
            return EmbeddedHeaderUtils.buildMessageValues(newPayload, headers, copyRequestHeaders, requestHeaders);
        }
        return EmbeddedHeaderUtils.buildMessageValues(payload, new HashMap<String, Object>(), copyRequestHeaders, requestHeaders);
    }

    public static MessageValues extractHeaders(byte[] payload) throws Exception {
        return EmbeddedHeaderUtils.extractHeaders(payload, false, null);
    }

    private static MessageValues buildMessageValues(byte[] payload, Map<String, Object> headers, boolean copyRequestHeaders, MessageHeaders requestHeaders) {
        MessageValues messageValues = new MessageValues(payload, headers);
        if (copyRequestHeaders && requestHeaders != null) {
            messageValues.copyHeadersIfAbsent((Map<String, Object>)requestHeaders);
        }
        return messageValues;
    }

    public static String[] headersToEmbed(String[] configuredHeaders) {
        String[] headersToMap;
        if (ObjectUtils.isEmpty((Object[])configuredHeaders)) {
            headersToMap = BinderHeaders.STANDARD_HEADERS;
        } else {
            String[] combinedHeadersToMap = Arrays.copyOfRange(BinderHeaders.STANDARD_HEADERS, 0, BinderHeaders.STANDARD_HEADERS.length + configuredHeaders.length);
            System.arraycopy(configuredHeaders, 0, combinedHeadersToMap, BinderHeaders.STANDARD_HEADERS.length, configuredHeaders.length);
            headersToMap = combinedHeadersToMap;
        }
        return headersToMap;
    }

    public static boolean mayHaveEmbeddedHeaders(byte[] bytes) {
        return bytes.length > 8 && (bytes[0] & 0xFF) == 255;
    }
}

