/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.BindableChannelFactory;
import org.springframework.cloud.stream.binding.ChannelBindingService;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BinderAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final ChannelBindingService channelBindingService;
    private final BindableChannelFactory bindableChannelFactory;
    private final DynamicDestinationsBindable dynamicDestinationsBindable;
    private ConfigurableListableBeanFactory beanFactory;

    public BinderAwareChannelResolver(ChannelBindingService channelBindingService, BindableChannelFactory bindableChannelFactory, DynamicDestinationsBindable dynamicDestinationsBindable) {
        this.dynamicDestinationsBindable = dynamicDestinationsBindable;
        Assert.notNull((Object)channelBindingService, (String)"'channelBindingService' cannot be null");
        Assert.notNull((Object)bindableChannelFactory, (String)"'bindableChannelFactory' cannot be null");
        this.channelBindingService = channelBindingService;
        this.bindableChannelFactory = bindableChannelFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel resolveDestination(String channelName) {
        SubscribableChannel channel = null;
        try {
            return super.resolveDestination(channelName);
        }
        catch (DestinationResolutionException e) {
            DestinationResolutionException destinationResolutionException = e;
            BinderAwareChannelResolver binderAwareChannelResolver = this;
            synchronized (binderAwareChannelResolver) {
                if (this.beanFactory != null) {
                    boolean dynamicAllowed;
                    Object[] dynamicDestinations = null;
                    ChannelBindingServiceProperties channelBindingServiceProperties = this.channelBindingService.getChannelBindingServiceProperties();
                    if (channelBindingServiceProperties != null) {
                        dynamicDestinations = channelBindingServiceProperties.getDynamicDestinations();
                    }
                    boolean bl = dynamicAllowed = ObjectUtils.isEmpty(dynamicDestinations) || ObjectUtils.containsElement((Object[])dynamicDestinations, (Object)channelName);
                    if (dynamicAllowed) {
                        channel = this.bindableChannelFactory.createOutputChannel(channelName);
                        this.beanFactory.registerSingleton(channelName, (Object)channel);
                        channel = (MessageChannel)this.beanFactory.initializeBean((Object)channel, channelName);
                        Binding<MessageChannel> binding = this.channelBindingService.bindProducer((MessageChannel)channel, channelName);
                        this.dynamicDestinationsBindable.addOutputBinding(channelName, binding);
                    } else {
                        throw destinationResolutionException;
                    }
                }
                return channel;
            }
        }
    }
}

