/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;
import org.springframework.util.MimeTypeUtils;

public class JsonToPojoMessageConverter
extends AbstractFromMessageConverter {
    private final ObjectMapper objectMapper;

    public JsonToPojoMessageConverter(ObjectMapper objectMapper) {
        super(MimeTypeUtils.APPLICATION_JSON, MessageConverterUtils.X_JAVA_OBJECT);
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{String.class, byte[].class};
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return null;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result = null;
        try {
            Object payload = message.getPayload();
            if (payload instanceof byte[]) {
                result = this.objectMapper.readValue((byte[])payload, targetClass);
            } else if (payload instanceof String) {
                result = this.objectMapper.readValue((String)payload, targetClass);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }
}

