/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.tuple.Tuple;
import org.springframework.tuple.TupleBuilder;
import org.springframework.util.MimeTypeUtils;

public class PojoToStringMessageConverter
extends AbstractFromMessageConverter {
    public PojoToStringMessageConverter() {
        super(MimeTypeUtils.TEXT_PLAIN);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{String.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return null;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String payloadString = null;
        if (message.getPayload() instanceof Tuple) {
            TupleBuilder builder = TupleBuilder.tuple();
            builder.putAll((Tuple)message.getPayload());
            payloadString = builder.build().toString();
        } else {
            payloadString = message.getPayload().toString();
        }
        return payloadString;
    }
}

