/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.Banner;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory<T>
implements BinderFactory<T>,
DisposableBean,
ApplicationContextAware {
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, BinderInstanceHolder<T>> binderInstanceCache = new HashMap<String, BinderInstanceHolder<T>>();
    private volatile ConfigurableApplicationContext context;
    private volatile String defaultBinder;
    private volatile CompositeHealthIndicator bindersHealthIndicator;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    @Autowired(required=false)
    @Qualifier(value="bindersHealthIndicator")
    public void setBindersHealthIndicator(CompositeHealthIndicator bindersHealthIndicator) {
        this.bindersHealthIndicator = bindersHealthIndicator;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, BinderInstanceHolder<T>> entry : this.binderInstanceCache.entrySet()) {
            BinderInstanceHolder<T> binderInstanceHolder = entry.getValue();
            binderInstanceHolder.getBinderContext().close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Binder<T, ?, ?> getBinder(String name) {
        boolean useApplicationContextAsParent;
        String configurationName;
        if (StringUtils.isEmpty((Object)name)) {
            if (this.binderConfigurations.size() == 0) {
                throw new IllegalStateException("A default binder has been requested, but there there is no binder available");
            }
            if (this.binderConfigurations.size() == 1) {
                configurationName = this.binderConfigurations.keySet().iterator().next();
            } else {
                if (!StringUtils.hasText((String)this.defaultBinder)) throw new IllegalStateException("A default binder has been requested, but there is more than one binder available: " + StringUtils.collectionToCommaDelimitedString(this.binderConfigurations.keySet()) + ", and" + " no default binder has been set.");
                configurationName = this.defaultBinder;
            }
        } else {
            configurationName = name;
        }
        if (this.binderInstanceCache.containsKey(configurationName)) return this.binderInstanceCache.get(configurationName).getBinderInstance();
        BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
        if (binderConfiguration == null) {
            throw new IllegalStateException("Unknown binder configuration: " + configurationName);
        }
        Properties binderProperties = binderConfiguration.getProperties();
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<Object, Object> property : binderProperties.entrySet()) {
            args.add(String.format("--%s=%s", property.getKey(), property.getValue()));
        }
        ConfigurableEnvironment environment = this.context != null ? this.context.getEnvironment() : null;
        String defaultDomain = environment != null ? environment.getProperty("spring.jmx.default-domain") : null;
        defaultDomain = defaultDomain == null ? "" : defaultDomain + ".";
        args.add("--spring.jmx.default-domain=" + defaultDomain + "binder." + configurationName);
        ArrayList configurationClasses = new ArrayList(Arrays.asList(binderConfiguration.getBinderType().getConfigurationClasses()));
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Object[0]).sources(configurationClasses.toArray(new Class[0])).bannerMode(Banner.Mode.OFF).web(false);
        boolean bl = useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
        if (useApplicationContextAsParent) {
            springApplicationBuilder.parent(this.context);
        }
        if (useApplicationContextAsParent || environment != null && binderConfiguration.isInheritEnvironment()) {
            StandardEnvironment binderEnvironment = new StandardEnvironment();
            binderEnvironment.merge(environment);
            springApplicationBuilder.environment((ConfigurableEnvironment)binderEnvironment);
        }
        ConfigurableApplicationContext binderProducingContext = springApplicationBuilder.run(args.toArray(new String[args.size()]));
        Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
        if (this.bindersHealthIndicator != null) {
            OrderedHealthAggregator healthAggregator = new OrderedHealthAggregator();
            Map indicators = binderProducingContext.getBeansOfType(HealthIndicator.class);
            DefaultHealthIndicator binderHealthIndicator = indicators.isEmpty() ? new DefaultHealthIndicator() : new CompositeHealthIndicator((HealthAggregator)healthAggregator, indicators);
            this.bindersHealthIndicator.addHealthIndicator(configurationName, (HealthIndicator)binderHealthIndicator);
        }
        this.binderInstanceCache.put(configurationName, new BinderInstanceHolder(binder, binderProducingContext));
        return this.binderInstanceCache.get(configurationName).getBinderInstance();
    }

    private static class DefaultHealthIndicator
    extends AbstractHealthIndicator {
        private DefaultHealthIndicator() {
        }

        protected void doHealthCheck(Health.Builder builder) throws Exception {
            builder.unknown();
        }
    }

    private static class BinderInstanceHolder<T> {
        private final Binder<T, ?, ?> binderInstance;
        private final ConfigurableApplicationContext binderContext;

        public BinderInstanceHolder(Binder<T, ?, ?> binderInstance, ConfigurableApplicationContext binderContext) {
            this.binderInstance = binderInstance;
            this.binderContext = binderContext;
        }

        public Binder<T, ?, ?> getBinderInstance() {
            return this.binderInstance;
        }

        public ConfigurableApplicationContext getBinderContext() {
            return this.binderContext;
        }
    }
}

