/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.tuple.Tuple;
import org.springframework.util.MimeTypeUtils;

public class TupleToJsonMessageConverter
extends AbstractFromMessageConverter {
    @Value(value="${typeconversion.json.prettyPrint:false}")
    private volatile boolean prettyPrint;
    private final ObjectMapper objectMapper;

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TupleToJsonMessageConverter(ObjectMapper objectMapper) {
        super(MimeTypeUtils.APPLICATION_JSON);
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{String.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{Tuple.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String json;
        Tuple t = (Tuple)message.getPayload();
        if (this.prettyPrint) {
            try {
                Object tmp = this.objectMapper.readValue(t.toString(), Object.class);
                json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(tmp);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        } else {
            json = t.toString();
        }
        return json;
    }
}

