/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.BindableChannelFactory;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BinderAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final BinderFactory<MessageChannel> binderFactory;
    private final ChannelBindingServiceProperties channelBindingServiceProperties;
    private final DynamicDestinationsBindable dynamicDestinationsBindable;
    private final BindableChannelFactory bindableChannelFactory;
    private ConfigurableListableBeanFactory beanFactory;

    public BinderAwareChannelResolver(BinderFactory binderFactory, ChannelBindingServiceProperties channelBindingServiceProperties, DynamicDestinationsBindable dynamicDestinationsBindable, BindableChannelFactory bindableChannelFactory) {
        Assert.notNull((Object)binderFactory, (String)"'binderFactory' cannot be null");
        Assert.notNull((Object)channelBindingServiceProperties, (String)"'channelBindingServiceProperties' cannot be null");
        Assert.notNull((Object)dynamicDestinationsBindable, (String)"'dynamicDestinationBindable' cannot be null");
        Assert.notNull((Object)bindableChannelFactory, (String)"'bindableChannelFactory' cannot be null");
        this.binderFactory = binderFactory;
        this.channelBindingServiceProperties = channelBindingServiceProperties;
        this.dynamicDestinationsBindable = dynamicDestinationsBindable;
        this.bindableChannelFactory = bindableChannelFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel resolveDestination(String channelName) {
        SubscribableChannel channel = null;
        try {
            return super.resolveDestination(channelName);
        }
        catch (DestinationResolutionException e) {
            DestinationResolutionException destinationResolutionException = e;
            BinderAwareChannelResolver binderAwareChannelResolver = this;
            synchronized (binderAwareChannelResolver) {
                if (this.beanFactory != null && this.binderFactory != null) {
                    boolean dynamicAllowed;
                    Object[] dynamicDestinations = null;
                    if (this.channelBindingServiceProperties != null) {
                        dynamicDestinations = this.channelBindingServiceProperties.getDynamicDestinations();
                    }
                    boolean bl = dynamicAllowed = ObjectUtils.isEmpty(dynamicDestinations) || ObjectUtils.containsElement((Object[])dynamicDestinations, (Object)channelName);
                    if (dynamicAllowed) {
                        String binderName = null;
                        String beanName = channelName;
                        if (channelName.contains(":")) {
                            String[] tokens = channelName.split(":", 2);
                            if (tokens.length == 2) {
                                binderName = tokens[0];
                                channelName = tokens[1];
                            } else if (tokens.length != 1) {
                                throw new IllegalArgumentException("Unrecognized channel naming scheme: " + channelName + " , should be" + " [<binder>:]<channelName>");
                            }
                        }
                        channel = this.bindableChannelFactory.createSubscribableChannel(channelName);
                        this.beanFactory.registerSingleton(beanName, (Object)channel);
                        channel = (MessageChannel)this.beanFactory.initializeBean((Object)channel, beanName);
                        Binder<MessageChannel, ?, ?> binder = this.binderFactory.getBinder(binderName);
                        ProducerProperties producerProperties = this.channelBindingServiceProperties.getProducerProperties(channelName);
                        String destinationName = this.channelBindingServiceProperties.getBindingDestination(channelName);
                        this.dynamicDestinationsBindable.addOutputBinding(beanName, binder.bindProducer(destinationName, (MessageChannel)channel, producerProperties));
                    } else {
                        throw destinationResolutionException;
                    }
                }
                return channel;
            }
        }
    }
}

