/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import org.springframework.cloud.stream.binder.ExpressionSerializer;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.expression.Expression;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ProducerProperties {
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionKeyExpression = null;
    private Class<?> partitionKeyExtractorClass = null;
    private Class<?> partitionSelectorClass = null;
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionSelectorExpression = null;
    private int partitionCount = 1;
    private String[] requiredGroups = new String[0];
    private HeaderMode headerMode = HeaderMode.embeddedHeaders;

    public Expression getPartitionKeyExpression() {
        return this.partitionKeyExpression;
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public Class<?> getPartitionKeyExtractorClass() {
        return this.partitionKeyExtractorClass;
    }

    public void setPartitionKeyExtractorClass(Class<?> partitionKeyExtractorClass) {
        this.partitionKeyExtractorClass = partitionKeyExtractorClass;
    }

    public boolean isPartitioned() {
        return this.partitionKeyExpression != null || this.partitionKeyExtractorClass != null;
    }

    public Class<?> getPartitionSelectorClass() {
        return this.partitionSelectorClass;
    }

    public void setPartitionSelectorClass(Class<?> partitionSelectorClass) {
        this.partitionSelectorClass = partitionSelectorClass;
    }

    public Expression getPartitionSelectorExpression() {
        return this.partitionSelectorExpression;
    }

    public void setPartitionSelectorExpression(Expression partitionSelectorExpression) {
        this.partitionSelectorExpression = partitionSelectorExpression;
    }

    @Min(value=1L, message="Partition count should be greater than zero.")
    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public String[] getRequiredGroups() {
        return this.requiredGroups;
    }

    public void setRequiredGroups(String ... requiredGroups) {
        this.requiredGroups = requiredGroups;
    }

    @AssertTrue(message="Partition key expression and partition key extractor class properties are mutually exclusive.")
    public boolean isValidPartitionKeyProperty() {
        return this.partitionKeyExpression == null || this.partitionKeyExtractorClass == null;
    }

    @AssertTrue(message="Partition selector class and partition selector expression properties are mutually exclusive.")
    public boolean isValidPartitionSelectorProperty() {
        return this.partitionSelectorClass == null || this.partitionSelectorExpression == null;
    }

    public HeaderMode getHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(HeaderMode headerMode) {
        this.headerMode = headerMode;
    }
}

