/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.test.junit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AbstractExternalResourceTestSupport<R>
implements TestRule {
    public static final String SCS_EXTERNAL_SERVERS_REQUIRED = "SCS_EXTERNAL_SERVERS_REQUIRED";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected R resource;
    private String resourceDescription;

    protected AbstractExternalResourceTestSupport(String resourceDescription) {
        org.springframework.util.Assert.hasText((String)resourceDescription, (String)"resourceDescription is required");
        this.resourceDescription = resourceDescription;
    }

    public Statement apply(final Statement base, Description description) {
        try {
            this.obtainResource();
        }
        catch (Exception e) {
            this.maybeCleanup();
            return this.failOrSkip(e);
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        AbstractExternalResourceTestSupport.this.cleanupResource();
                    }
                    catch (Exception ignored) {
                        AbstractExternalResourceTestSupport.this.logger.warn((Object)"Exception while trying to cleanup proper resource", (Throwable)ignored);
                    }
                }
            }
        };
    }

    private Statement failOrSkip(final Exception e) {
        String serversRequired = System.getenv(SCS_EXTERNAL_SERVERS_REQUIRED);
        if ("true".equalsIgnoreCase(serversRequired)) {
            this.logger.error((Object)(this.resourceDescription + " IS REQUIRED BUT NOT AVAILABLE"), (Throwable)e);
            Assert.fail((String)(this.resourceDescription + " IS NOT AVAILABLE"));
            return null;
        }
        this.logger.error((Object)(this.resourceDescription + " IS NOT AVAILABLE, SKIPPING TESTS"), (Throwable)e);
        return new Statement(){

            public void evaluate() throws Throwable {
                Assume.assumeTrue((String)("Skipping test due to " + AbstractExternalResourceTestSupport.this.resourceDescription + " not being available " + e), (boolean)false);
            }
        };
    }

    private void maybeCleanup() {
        if (this.resource != null) {
            try {
                this.cleanupResource();
            }
            catch (Exception ignored) {
                this.logger.warn((Object)"Exception while trying to cleanup failed resource", (Throwable)ignored);
            }
        }
    }

    public R getResource() {
        return this.resource;
    }

    protected abstract void cleanupResource() throws Exception;

    protected abstract void obtainResource() throws Exception;
}

