/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.cloud.stream.binder.test.TestChannelBinder;
import org.springframework.cloud.stream.binder.test.TestChannelBinderProvisioner;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.config.EnableIntegration;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={BinderFactoryAutoConfiguration.class})
@EnableIntegration
public class TestChannelBinderConfiguration<T> {
    public static final String NAME = "integration";

    public static Class<?>[] getCompleteConfiguration(Class<?> ... additionalConfigurationClasses) {
        ArrayList configClasses = new ArrayList();
        configClasses.add(TestChannelBinderConfiguration.class);
        configClasses.add(BindingServiceConfiguration.class);
        if (additionalConfigurationClasses != null) {
            configClasses.addAll(Arrays.asList(additionalConfigurationClasses));
        }
        return configClasses.toArray(new Class[0]);
    }

    public static ApplicationContextRunner applicationContextRunner(Class<?> ... additionalConfigurationClasses) {
        return (ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration((Class[])TestChannelBinderConfiguration.getCompleteConfiguration(additionalConfigurationClasses));
    }

    @Bean
    public InputDestination sourceDestination() {
        return new InputDestination();
    }

    @Bean
    public OutputDestination targetDestination() {
        return new OutputDestination();
    }

    @Bean
    public Binder<T, ? extends ConsumerProperties, ? extends ProducerProperties> springIntegrationChannelBinder(TestChannelBinderProvisioner provisioner) {
        return new TestChannelBinder(provisioner);
    }

    @Bean
    public TestChannelBinderProvisioner springIntegrationProvisioner() {
        return new TestChannelBinderProvisioner();
    }
}

