/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.RabbitHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.cloud.CloudAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.rabbit.config.RabbitMessageChannelBinderConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={RabbitMessageChannelBinderConfiguration.class})
@AutoConfigureBefore(value={CloudAutoConfiguration.class, RabbitAutoConfiguration.class})
public class RabbitServiceAutoConfiguration {
    @Bean
    public HealthIndicator binderHealthIndicator(RabbitTemplate rabbitTemplate) {
        return new RabbitHealthIndicator(rabbitTemplate);
    }

    @Configuration
    @Profile(value={"!cloud"})
    @Import(value={RabbitAutoConfiguration.class})
    protected static class NoCloudConfig {
        protected NoCloudConfig() {
        }
    }

    @Configuration
    @Profile(value={"cloud"})
    @ConditionalOnClass(value={Cloud.class})
    protected static class CloudConfig {
        protected CloudConfig() {
        }

        @Bean
        public Cloud cloud() {
            return new CloudFactory().getCloud();
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectionFactory.class})
        ConnectionFactory rabbitConnectionFactory(Cloud cloud) {
            return (ConnectionFactory)cloud.getSingletonServiceConnector(ConnectionFactory.class, null);
        }
    }
}

