/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test.junit.rabbit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.cloud.stream.binder.test.junit.rabbit.AbstractExternalResourceTestSupport;

public class RabbitTestSupport
extends AbstractExternalResourceTestSupport<CachingConnectionFactory> {
    private final boolean management;
    private final int ampqPort;
    private final int managmentPort;

    public RabbitTestSupport() {
        this(false);
    }

    public RabbitTestSupport(boolean management) {
        this(management, 5672, 15672);
    }

    public RabbitTestSupport(boolean management, int amqpPort, int managementPort) {
        super("RABBIT");
        this.management = management;
        this.ampqPort = amqpPort;
        this.managmentPort = managementPort;
    }

    @Override
    protected void obtainResource() throws Exception {
        this.resource = new CachingConnectionFactory("localhost", this.ampqPort);
        ((CachingConnectionFactory)this.resource).createConnection().close();
        if (this.management) {
            Socket socket = SocketFactory.getDefault().createSocket("localhost", this.managmentPort);
            socket.close();
        }
    }

    @Override
    protected void cleanupResource() throws Exception {
        ((CachingConnectionFactory)this.resource).destroy();
    }

    public static class RabbitProxy {
        private static final Log LOGGER = LogFactory.getLog(RabbitProxy.class);
        private final int port;
        private final ExecutorService serverExec = Executors.newSingleThreadExecutor();
        private final ExecutorService socketExec = Executors.newCachedThreadPool();
        private volatile ServerSocket serverSocket;

        public RabbitProxy() throws IOException {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(0);
            this.port = serverSocket.getLocalPort();
            serverSocket.close();
        }

        public int getPort() {
            return this.port;
        }

        public void start() throws IOException {
            this.start(5672);
        }

        public void start(final int amqpPort) throws IOException {
            this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port, 10);
            LOGGER.info((Object)"Proxy started");
            this.serverExec.execute(new Runnable(){
                final /* synthetic */ RabbitProxy this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        while (true) {
                            final Socket socket = this.this$0.serverSocket.accept();
                            LOGGER.info((Object)"Accepted Connection");
                            this.this$0.socketExec.execute(new Runnable(){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        int c;
                                        final Socket rabbitSocket = SocketFactory.getDefault().createSocket("localhost", amqpPort);
                                        this.this$1.this$0.socketExec.execute(new Runnable(){
                                            final /* synthetic */ RabbitProxy.1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                LOGGER.info((Object)("Running: " + rabbitSocket.getLocalPort()));
                                                try {
                                                    int c;
                                                    InputStream is = rabbitSocket.getInputStream();
                                                    OutputStream os = socket.getOutputStream();
                                                    while ((c = is.read()) >= 0) {
                                                        os.write(c);
                                                    }
                                                }
                                                catch (IOException e) {
                                                    try {
                                                        socket.close();
                                                        rabbitSocket.close();
                                                    }
                                                    catch (IOException iOException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                        });
                                        InputStream is = socket.getInputStream();
                                        OutputStream os = rabbitSocket.getOutputStream();
                                        while ((c = is.read()) >= 0) {
                                            os.write(c);
                                        }
                                    }
                                    catch (IOException e) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        try {
                            this.this$0.serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            });
        }

        public void stop() throws IOException {
            this.serverSocket.close();
        }
    }
}

