/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.springframework.cloud.stream.binder.pulsar.properties.ConsumerConfigProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.ProducerConfigProperties;
import org.springframework.cloud.stream.binder.pulsar.properties.PulsarConsumerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.StringUtils;

final class PulsarBinderUtils {
    private static final LogAccessor LOGGER = new LogAccessor(PulsarBinderUtils.class);
    private static final String SUBSCRIPTION_NAME_FORMAT_STR = "%s-anon-subscription-%s";

    private PulsarBinderUtils() {
    }

    static String subscriptionName(PulsarConsumerProperties consumerProps, ConsumerDestination consumerDestination) {
        if (StringUtils.hasText((String)consumerProps.getSubscription().getName())) {
            return consumerProps.getSubscription().getName();
        }
        return SUBSCRIPTION_NAME_FORMAT_STR.formatted(consumerDestination.getName(), UUID.randomUUID());
    }

    static Map<String, Object> mergeModifiedProducerProperties(ProducerConfigProperties binderProducerProps, ProducerConfigProperties bindingProducerProps) {
        Map<String, Object> globalProducerProps = new ProducerConfigProperties().toBaseProducerPropertiesMap();
        Map<String, Object> binderBaseProducerProps = binderProducerProps.toBaseProducerPropertiesMap();
        Map<String, Object> bindingBaseProducerProps = bindingProducerProps.toBaseProducerPropertiesMap();
        Map<String, Object> layeredBaseProducerProps = PulsarBinderUtils.mergePropertiesWithPrecedence(globalProducerProps, binderBaseProducerProps, bindingBaseProducerProps, false);
        Map<String, Object> globalExtProducerProps = new ProducerConfigProperties().toExtendedProducerPropertiesMap();
        Map<String, Object> binderExtProducerProps = binderProducerProps.toExtendedProducerPropertiesMap();
        Map<String, Object> bindingExtProducerProps = bindingProducerProps.toExtendedProducerPropertiesMap();
        Map<String, Object> layeredExtProducerProps = PulsarBinderUtils.mergePropertiesWithPrecedence(globalExtProducerProps, binderExtProducerProps, bindingExtProducerProps, true);
        HashMap<String, Object> layeredProducerProps = new HashMap<String, Object>(layeredBaseProducerProps);
        layeredProducerProps.putAll(layeredExtProducerProps);
        return layeredProducerProps;
    }

    static Map<String, Object> mergeModifiedConsumerProperties(ConsumerConfigProperties binderConsumerProps, ConsumerConfigProperties bindingConsumerProps) {
        Map<String, Object> globalBaseConsumerProps = new ConsumerConfigProperties().toBaseConsumerPropertiesMap();
        Map<String, Object> binderBaseConsumerProps = binderConsumerProps.toBaseConsumerPropertiesMap();
        Map<String, Object> bindingBaseConsumerProps = bindingConsumerProps.toBaseConsumerPropertiesMap();
        Map<String, Object> layeredBaseConsumerProps = PulsarBinderUtils.mergePropertiesWithPrecedence(globalBaseConsumerProps, binderBaseConsumerProps, bindingBaseConsumerProps, false);
        Map<String, Object> globalExtConsumerProps = new ConsumerConfigProperties().toExtendedConsumerPropertiesMap();
        Map<String, Object> binderExtConsumerProps = binderConsumerProps.toExtendedConsumerPropertiesMap();
        Map<String, Object> bindingExtConsumerProps = bindingConsumerProps.toExtendedConsumerPropertiesMap();
        Map<String, Object> layeredExtConsumerProps = PulsarBinderUtils.mergePropertiesWithPrecedence(globalExtConsumerProps, binderExtConsumerProps, bindingExtConsumerProps, true);
        HashMap<String, Object> layeredConsumerProps = new HashMap<String, Object>(layeredBaseConsumerProps);
        layeredConsumerProps.putAll(layeredExtConsumerProps);
        return layeredConsumerProps;
    }

    static Map<String, Object> mergePropertiesWithPrecedence(Map<String, Object> globalProps, Map<String, Object> binderProps, Map<String, Object> bindingProps, boolean includeDefaults) {
        Objects.requireNonNull(globalProps, "globalProps must be specified");
        Objects.requireNonNull(binderProps, "binderProps must be specified");
        Objects.requireNonNull(bindingProps, "bindingProps must be specified");
        Map<String, Object> newOrModifiedBinderProps = PulsarBinderUtils.extractNewOrModifiedProperties(binderProps, globalProps);
        LOGGER.trace(() -> "New or modified binder props: %s".formatted(newOrModifiedBinderProps));
        Map<String, Object> newOrModifiedBindingProps = PulsarBinderUtils.extractNewOrModifiedProperties(bindingProps, globalProps);
        LOGGER.trace(() -> "New or modified binding props: %s".formatted(newOrModifiedBindingProps));
        HashMap<String, Object> mergedProps = new HashMap<String, Object>(newOrModifiedBinderProps);
        mergedProps.putAll(newOrModifiedBindingProps);
        if (includeDefaults) {
            globalProps.forEach(mergedProps::putIfAbsent);
        }
        LOGGER.trace(() -> "Final merged props: %s".formatted(mergedProps));
        return mergedProps;
    }

    private static Map<String, Object> extractNewOrModifiedProperties(Map<String, Object> candidateProps, Map<String, Object> baseProps) {
        HashMap<String, Object> newOrModifiedProps = new HashMap<String, Object>();
        candidateProps.forEach((propName, propValue) -> {
            if (!baseProps.containsKey(propName) || !Objects.equals(propValue, baseProps.get(propName))) {
                newOrModifiedProps.put((String)propName, propValue);
            }
        });
        return newOrModifiedProps;
    }

    static <T> void loadConf(ProducerBuilder<T> builder, Map<String, Object> properties) {
        builder.loadConf(properties);
        if (properties.containsKey("encryptionKeys")) {
            Collection keys = (Collection)properties.get("encryptionKeys");
            keys.forEach(arg_0 -> builder.addEncryptionKey(arg_0));
        }
        if (properties.containsKey("customMessageRouter")) {
            builder.messageRouter((MessageRouter)properties.get("customMessageRouter"));
        }
        if (properties.containsKey("batcherBuilder")) {
            builder.batcherBuilder((BatcherBuilder)properties.get("batcherBuilder"));
        }
        if (properties.containsKey("cryptoKeyReader")) {
            builder.cryptoKeyReader((CryptoKeyReader)properties.get("cryptoKeyReader"));
        }
    }
}

