/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.stream.kinesis.binder")
public class KinesisBinderConfigurationProperties {
    private String[] headers = new String[0];
    private int describeStreamBackoff = 1000;
    private int describeStreamRetries = 50;
    private boolean autoCreateStream = true;
    private boolean autoAddShards = false;
    private int minShardCount = 1;
    private final Checkpoint checkpoint = new Checkpoint();
    private final Locks locks = new Locks();

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    public int getDescribeStreamBackoff() {
        return this.describeStreamBackoff;
    }

    public void setDescribeStreamBackoff(int describeStreamBackoff) {
        this.describeStreamBackoff = describeStreamBackoff;
    }

    public int getDescribeStreamRetries() {
        return this.describeStreamRetries;
    }

    public void setDescribeStreamRetries(int describeStreamRetries) {
        this.describeStreamRetries = describeStreamRetries;
    }

    public boolean isAutoAddShards() {
        return this.autoAddShards;
    }

    public void setAutoAddShards(boolean autoAddShards) {
        this.autoAddShards = autoAddShards;
    }

    public int getMinShardCount() {
        return this.minShardCount;
    }

    public void setMinShardCount(int minShardCount) {
        this.minShardCount = minShardCount;
    }

    public Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Locks getLocks() {
        return this.locks;
    }

    public boolean isAutoCreateStream() {
        return this.autoCreateStream;
    }

    public void setAutoCreateStream(boolean autoCreateStream) {
        this.autoCreateStream = autoCreateStream;
    }

    public static class Locks {
        private String table = "SpringIntegrationLockRegistry";
        private long readCapacity = 1L;
        private long writeCapacity = 1L;
        private String partitionKey = "lockKey";
        private String sortKeyName = "sortKey";
        private String sortKey = "SpringIntegrationLocks";
        private long refreshPeriod = 1000L;
        private long leaseDuration = 20L;
        private long heartbeatPeriod = 5L;

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public long getReadCapacity() {
            return this.readCapacity;
        }

        public void setReadCapacity(long readCapacity) {
            this.readCapacity = readCapacity;
        }

        public long getWriteCapacity() {
            return this.writeCapacity;
        }

        public void setWriteCapacity(long writeCapacity) {
            this.writeCapacity = writeCapacity;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public String getSortKeyName() {
            return this.sortKeyName;
        }

        public void setSortKeyName(String sortKeyName) {
            this.sortKeyName = sortKeyName;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        public long getRefreshPeriod() {
            return this.refreshPeriod;
        }

        public void setRefreshPeriod(long refreshPeriod) {
            this.refreshPeriod = refreshPeriod;
        }

        public long getLeaseDuration() {
            return this.leaseDuration;
        }

        public void setLeaseDuration(long leaseDuration) {
            this.leaseDuration = leaseDuration;
        }

        public long getHeartbeatPeriod() {
            return this.heartbeatPeriod;
        }

        public void setHeartbeatPeriod(long heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
        }
    }

    public static class Checkpoint {
        private String table = "SpringIntegrationMetadataStore";
        private long readCapacity = 1L;
        private long writeCapacity = 1L;
        private int createDelay = 1;
        private int createRetries = 25;
        private Integer timeToLive;

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public long getReadCapacity() {
            return this.readCapacity;
        }

        public void setReadCapacity(long readCapacity) {
            this.readCapacity = readCapacity;
        }

        public long getWriteCapacity() {
            return this.writeCapacity;
        }

        public void setWriteCapacity(long writeCapacity) {
            this.writeCapacity = writeCapacity;
        }

        public int getCreateDelay() {
            return this.createDelay;
        }

        public void setCreateDelay(int createDelay) {
            this.createDelay = createDelay;
        }

        public int getCreateRetries() {
            return this.createRetries;
        }

        public void setCreateRetries(int createRetries) {
            this.createRetries = createRetries;
        }

        public Integer getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }
    }
}

