/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderHeaders;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisConsumerProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisProducerProperties;
import org.springframework.cloud.stream.binder.kinesis.provisioning.KinesisConsumerDestination;
import org.springframework.cloud.stream.binder.kinesis.provisioning.KinesisStreamProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.aws.inbound.kinesis.KinesisMessageDrivenChannelAdapter;
import org.springframework.integration.aws.inbound.kinesis.KinesisMessageHeaderErrorMessageStrategy;
import org.springframework.integration.aws.inbound.kinesis.KinesisShardOffset;
import org.springframework.integration.aws.outbound.KinesisMessageHandler;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class KinesisMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<KinesisConsumerProperties>, ExtendedProducerProperties<KinesisProducerProperties>, KinesisStreamProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, KinesisConsumerProperties, KinesisProducerProperties> {
    private static final ErrorMessageStrategy ERROR_MESSAGE_STRATEGY = new KinesisMessageHeaderErrorMessageStrategy();
    private final KinesisBinderConfigurationProperties configurationProperties;
    private KinesisExtendedBindingProperties extendedBindingProperties = new KinesisExtendedBindingProperties();
    private final AmazonKinesisAsync amazonKinesis;
    private ConcurrentMetadataStore checkpointStore;
    private LockRegistry lockRegistry;
    private EvaluationContext evaluationContext;

    public KinesisMessageChannelBinder(AmazonKinesisAsync amazonKinesis, KinesisBinderConfigurationProperties configurationProperties, KinesisStreamProvisioner provisioningProvider) {
        super(KinesisMessageChannelBinder.headersToMap(configurationProperties), (ProvisioningProvider)provisioningProvider);
        Assert.notNull((Object)amazonKinesis, (String)"'amazonKinesis' must not be null");
        this.configurationProperties = configurationProperties;
        this.amazonKinesis = amazonKinesis;
    }

    public void setExtendedBindingProperties(KinesisExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void setCheckpointStore(ConcurrentMetadataStore checkpointStore) {
        this.checkpointStore = checkpointStore;
    }

    public void setLockRegistry(LockRegistry lockRegistry) {
        this.lockRegistry = lockRegistry;
    }

    public KinesisConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public KinesisProducerProperties getExtendedProducerProperties(String channelName) {
        return this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<KinesisProducerProperties> producerProperties, MessageChannel errorChannel) {
        KinesisMessageHandler kinesisMessageHandler = new KinesisMessageHandler(this.amazonKinesis);
        kinesisMessageHandler.setSync(((KinesisProducerProperties)producerProperties.getExtension()).isSync());
        kinesisMessageHandler.setSendTimeout(((KinesisProducerProperties)producerProperties.getExtension()).getSendTimeout());
        kinesisMessageHandler.setStream(destination.getName());
        kinesisMessageHandler.setPartitionKeyExpression((Expression)new FunctionExpression(m -> m.getHeaders().containsKey((Object)"scst_partition") ? m.getHeaders().get((Object)"scst_partition") : Integer.valueOf(m.getPayload().hashCode())));
        kinesisMessageHandler.setFailureChannel(errorChannel);
        kinesisMessageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        return kinesisMessageHandler;
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, final ExtendedProducerProperties<KinesisProducerProperties> producerProperties) {
        if (outputChannel instanceof ChannelInterceptorAware && producerProperties.isPartitioned()) {
            ((ChannelInterceptorAware)outputChannel).addInterceptor(0, new ChannelInterceptor(){

                public Message<?> preSend(Message<?> message, MessageChannel channel) {
                    Object partitionKey = producerProperties.getPartitionKeyExpression().getValue(KinesisMessageChannelBinder.this.evaluationContext, message);
                    return MessageBuilder.fromMessage(message).setHeader("scst_partitionOverride", partitionKey).build();
                }
            });
        }
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<KinesisConsumerProperties> properties) {
        KinesisConsumerProperties kinesisConsumerProperties = (KinesisConsumerProperties)properties.getExtension();
        HashSet<KinesisShardOffset> shardOffsets = null;
        String shardIteratorType = kinesisConsumerProperties.getShardIteratorType();
        KinesisShardOffset kinesisShardOffset = KinesisShardOffset.latest();
        if (StringUtils.hasText((String)shardIteratorType)) {
            String[] typeValue = shardIteratorType.split(":", 2);
            ShardIteratorType iteratorType = ShardIteratorType.valueOf((String)typeValue[0]);
            kinesisShardOffset = new KinesisShardOffset(iteratorType);
            if (typeValue.length > 1) {
                if (ShardIteratorType.AT_TIMESTAMP.equals((Object)iteratorType)) {
                    kinesisShardOffset.setTimestamp(new Date(Long.parseLong(typeValue[1])));
                } else {
                    kinesisShardOffset.setSequenceNumber(typeValue[1]);
                }
            }
        }
        if (properties.getInstanceCount() > 1) {
            shardOffsets = new HashSet<KinesisShardOffset>();
            KinesisConsumerDestination kinesisConsumerDestination = (KinesisConsumerDestination)destination;
            List<Shard> shards = kinesisConsumerDestination.getShards();
            for (int i = 0; i < shards.size(); ++i) {
                if (i % properties.getInstanceCount() != properties.getInstanceIndex()) continue;
                KinesisShardOffset shardOffset = new KinesisShardOffset(kinesisShardOffset);
                shardOffset.setStream(destination.getName());
                shardOffset.setShard(shards.get(i).getShardId());
                shardOffsets.add(shardOffset);
            }
        }
        KinesisMessageDrivenChannelAdapter adapter = CollectionUtils.isEmpty(shardOffsets) ? new KinesisMessageDrivenChannelAdapter((AmazonKinesis)this.amazonKinesis, new String[]{destination.getName()}) : new KinesisMessageDrivenChannelAdapter((AmazonKinesis)this.amazonKinesis, shardOffsets.toArray(new KinesisShardOffset[0]));
        boolean anonymous = !StringUtils.hasText((String)group);
        String consumerGroup = anonymous ? "anonymous." + UUID.randomUUID().toString() : group;
        adapter.setConsumerGroup(consumerGroup);
        adapter.setStreamInitialSequence(anonymous || StringUtils.hasText((String)shardIteratorType) ? kinesisShardOffset : KinesisShardOffset.trimHorizon());
        adapter.setListenerMode(kinesisConsumerProperties.getListenerMode());
        if (properties.isUseNativeDecoding()) {
            adapter.setConverter(null);
        } else {
            adapter.setConverter(bytes -> bytes);
        }
        adapter.setCheckpointMode(kinesisConsumerProperties.getCheckpointMode());
        adapter.setRecordsLimit(kinesisConsumerProperties.getRecordsLimit());
        adapter.setIdleBetweenPolls(kinesisConsumerProperties.getIdleBetweenPolls());
        adapter.setConsumerBackoff(kinesisConsumerProperties.getConsumerBackoff());
        if (this.checkpointStore != null) {
            adapter.setCheckpointStore(this.checkpointStore);
        }
        adapter.setLockRegistry(this.lockRegistry);
        adapter.setConcurrency(properties.getConcurrency());
        adapter.setStartTimeout(kinesisConsumerProperties.getStartTimeout());
        adapter.setDescribeStreamBackoff(this.configurationProperties.getDescribeStreamBackoff());
        adapter.setDescribeStreamRetries(this.configurationProperties.getDescribeStreamRetries());
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, consumerGroup, (ConsumerProperties)properties);
        adapter.setErrorMessageStrategy(ERROR_MESSAGE_STRATEGY);
        adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        return adapter;
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return ERROR_MESSAGE_STRATEGY;
    }

    private static String[] headersToMap(KinesisBinderConfigurationProperties configurationProperties) {
        Assert.notNull((Object)configurationProperties, (String)"'configurationProperties' must not be null");
        if (ObjectUtils.isEmpty((Object[])configurationProperties.getHeaders())) {
            return BinderHeaders.STANDARD_HEADERS;
        }
        String[] combinedHeadersToMap = Arrays.copyOfRange(BinderHeaders.STANDARD_HEADERS, 0, BinderHeaders.STANDARD_HEADERS.length + configurationProperties.getHeaders().length);
        System.arraycopy(configurationProperties.getHeaders(), 0, combinedHeadersToMap, BinderHeaders.STANDARD_HEADERS.length, configurationProperties.getHeaders().length);
        return combinedHeadersToMap;
    }
}

