/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;

public class KafkaBinderJaasInitializerListener
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware,
DisposableBean {
    public static final String DEFAULT_ZK_LOGIN_CONTEXT_NAME = "Client";
    private ApplicationContext applicationContext;
    private final boolean ignoreJavaLoginConfigParamSystemProperty = System.getProperty("java.security.auth.login.config") == null;
    private final File placeholderJaasConfiguration = File.createTempFile("kafka-client-jaas-config-placeholder", "conf");

    public KafkaBinderJaasInitializerListener() throws IOException {
        this.placeholderJaasConfiguration.deleteOnExit();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        if (this.ignoreJavaLoginConfigParamSystemProperty) {
            System.clearProperty("java.security.auth.login.config");
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getSource() == this.applicationContext) {
            KafkaBinderConfigurationProperties binderConfigurationProperties = (KafkaBinderConfigurationProperties)this.applicationContext.getBean(KafkaBinderConfigurationProperties.class);
            if (this.ignoreJavaLoginConfigParamSystemProperty && binderConfigurationProperties.getJaas() != null) {
                HashMap<String, AppConfigurationEntry[]> configurationEntries = new HashMap<String, AppConfigurationEntry[]>();
                AppConfigurationEntry kafkaClientConfigurationEntry = new AppConfigurationEntry(binderConfigurationProperties.getJaas().getLoginModule(), binderConfigurationProperties.getJaas().getControlFlagValue(), binderConfigurationProperties.getJaas().getOptions() != null ? binderConfigurationProperties.getJaas().getOptions() : Collections.emptyMap());
                configurationEntries.put("KafkaClient", new AppConfigurationEntry[]{kafkaClientConfigurationEntry});
                Configuration.setConfiguration(new InternalConfiguration(configurationEntries));
                if (this.placeholderJaasConfiguration != null) {
                    System.setProperty("java.security.auth.login.config", this.placeholderJaasConfiguration.getAbsolutePath());
                }
            }
        }
    }

    public static class InternalConfiguration
    extends Configuration {
        private final Map<String, AppConfigurationEntry[]> configurationEntries;

        public InternalConfiguration(Map<String, AppConfigurationEntry[]> configurationEntries) {
            Assert.notNull(configurationEntries, (String)" cannot be null");
            Assert.notEmpty(configurationEntries, (String)" cannot be empty");
            this.configurationEntries = configurationEntries;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.configurationEntries.get(name);
        }
    }
}

