/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfigurationProperties;

public class KafkaBinderHealthIndicator
implements HealthIndicator {
    private final KafkaMessageChannelBinder binder;
    private final KafkaBinderConfigurationProperties configurationProperties;

    public KafkaBinderHealthIndicator(KafkaMessageChannelBinder binder, KafkaBinderConfigurationProperties configurationProperties) {
        this.binder = binder;
        this.configurationProperties = configurationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Health health() {
        Object object;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("bootstrap.servers", this.configurationProperties.getKafkaConnectionString());
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        try (KafkaConsumer metadataConsumer = new KafkaConsumer(properties);){
            HashSet<String> downMessages = new HashSet<String>();
            for (String topic : this.binder.getTopicsInUse().keySet()) {
                List partitionInfos = metadataConsumer.partitionsFor(topic);
                for (PartitionInfo partitionInfo : partitionInfos) {
                    if (!this.binder.getTopicsInUse().get(topic).contains(partitionInfo) || partitionInfo.leader().id() != -1) continue;
                    downMessages.add(partitionInfo.toString());
                }
            }
            if (downMessages.isEmpty()) {
                object = Health.up().build();
                return object;
            }
            object = Health.down().withDetail("Following partitions in use have no leaders: ", (Object)((Object)downMessages).toString()).build();
            return object;
        }
    }
}

