/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.config.codec.kryo.KryoCodecAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.kafka.support.LoggingProducerListener;
import org.springframework.integration.kafka.support.ProducerListener;
import org.springframework.integration.kafka.support.ZookeeperConnect;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KryoCodecAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={KafkaBinderConfigurationProperties.class, KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    @Autowired
    private Codec codec;
    @Autowired
    private KafkaBinderConfigurationProperties kafkaBinderConfigurationProperties;
    @Autowired
    private KafkaExtendedBindingProperties kafkaExtendedBindingProperties;
    @Autowired
    private ProducerListener producerListener;

    @Bean
    ZookeeperConnect zookeeperConnect() {
        ZookeeperConnect zookeeperConnect = new ZookeeperConnect();
        zookeeperConnect.setZkConnect(this.kafkaBinderConfigurationProperties.getZkConnectionString());
        return zookeeperConnect;
    }

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder() {
        String[] headers = this.kafkaBinderConfigurationProperties.getHeaders();
        String kafkaConnectionString = this.kafkaBinderConfigurationProperties.getKafkaConnectionString();
        String zkConnectionString = this.kafkaBinderConfigurationProperties.getZkConnectionString();
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(this.zookeeperConnect(), kafkaConnectionString, zkConnectionString, headers);
        kafkaMessageChannelBinder.setCodec(this.codec);
        kafkaMessageChannelBinder.setOffsetUpdateTimeWindow(this.kafkaBinderConfigurationProperties.getOffsetUpdateTimeWindow());
        kafkaMessageChannelBinder.setOffsetUpdateCount(this.kafkaBinderConfigurationProperties.getOffsetUpdateCount());
        kafkaMessageChannelBinder.setOffsetUpdateShutdownTimeout(this.kafkaBinderConfigurationProperties.getOffsetUpdateShutdownTimeout());
        kafkaMessageChannelBinder.setZkSessionTimeout(this.kafkaBinderConfigurationProperties.getZkSessionTimeout());
        kafkaMessageChannelBinder.setZkConnectionTimeout(this.kafkaBinderConfigurationProperties.getZkConnectionTimeout());
        kafkaMessageChannelBinder.setFetchSize(this.kafkaBinderConfigurationProperties.getFetchSize());
        kafkaMessageChannelBinder.setMinPartitionCount(this.kafkaBinderConfigurationProperties.getMinPartitionCount());
        kafkaMessageChannelBinder.setQueueSize(this.kafkaBinderConfigurationProperties.getQueueSize());
        kafkaMessageChannelBinder.setReplicationFactor(this.kafkaBinderConfigurationProperties.getReplicationFactor());
        kafkaMessageChannelBinder.setRequiredAcks(this.kafkaBinderConfigurationProperties.getRequiredAcks());
        kafkaMessageChannelBinder.setMaxWait(this.kafkaBinderConfigurationProperties.getMaxWait());
        kafkaMessageChannelBinder.setAutoCreateTopics(this.kafkaBinderConfigurationProperties.isAutoCreateTopics());
        kafkaMessageChannelBinder.setAutoAddPartitions(this.kafkaBinderConfigurationProperties.isAutoAddPartitions());
        kafkaMessageChannelBinder.setProducerListener(this.producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(this.kafkaExtendedBindingProperties);
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    KafkaBinderHealthIndicator healthIndicator(KafkaMessageChannelBinder kafkaMessageChannelBinder) {
        return new KafkaBinderHealthIndicator(kafkaMessageChannelBinder);
    }
}

