/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.serializer.JacksonJsonSerde;

abstract class SerdeResolverUtils {
    private static final Log LOG = LogFactory.getLog(SerdeResolverUtils.class);
    private static final Set<String> STANDARD_SERDE_CLASSNAMES = Set.of(Serdes.String().getClass().getName(), Serdes.Short().getClass().getName(), Serdes.Integer().getClass().getName(), Serdes.Long().getClass().getName(), Serdes.Float().getClass().getName(), Serdes.Double().getClass().getName(), Serdes.ByteArray().getClass().getName(), Serdes.ByteBuffer().getClass().getName(), Serdes.Bytes().getClass().getName(), Serdes.UUID().getClass().getName());

    SerdeResolverUtils() {
    }

    static Serde<?> resolveForType(ConfigurableApplicationContext context, ResolvableType targetType, Serde<?> fallbackSerde) {
        Class genericRawClazz = targetType.getRawClass();
        if (genericRawClazz == null) {
            return fallbackSerde;
        }
        List<String> matchingSerdes = SerdeResolverUtils.beanNamesForMatchingSerdes(context, targetType);
        if (!matchingSerdes.isEmpty()) {
            return (Serde)context.getBean(matchingSerdes.get(0), Serde.class);
        }
        Serde<?> standardDefaultSerde = SerdeResolverUtils.getStandardDefaultSerde(genericRawClazz);
        if (standardDefaultSerde != null) {
            return standardDefaultSerde;
        }
        if (fallbackSerde != null && !SerdeResolverUtils.isSerdeFromStandardDefaults(fallbackSerde)) {
            return fallbackSerde;
        }
        if (!genericRawClazz.isAssignableFrom(Object.class)) {
            return new JacksonJsonSerde(genericRawClazz);
        }
        return fallbackSerde;
    }

    private static Serde<?> getStandardDefaultSerde(Class<?> genericRawClazz) {
        try {
            return Serdes.serdeFrom(genericRawClazz);
        }
        catch (IllegalArgumentException ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)ex);
            }
            return null;
        }
    }

    private static boolean isSerdeFromStandardDefaults(Serde<?> serde) {
        if (serde == null) {
            return false;
        }
        return STANDARD_SERDE_CLASSNAMES.contains(serde.getClass().getName());
    }

    static List<String> beanNamesForMatchingSerdes(ConfigurableApplicationContext context, ResolvableType targetType) {
        if (targetType.getRawClass() == null) {
            return Collections.emptyList();
        }
        ArrayList matchingSerdes = new ArrayList();
        ResolvableType serdeType = ResolvableType.forClassWithGenerics(Serde.class, (ResolvableType[])new ResolvableType[]{targetType});
        String[] serdeBeanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), (ResolvableType)serdeType, (boolean)false, (boolean)false);
        Arrays.stream(serdeBeanNames).forEach(beanName -> {
            try {
                BeanDefinition beanDefinition = context.getBeanFactory().getMergedBeanDefinition(beanName);
                ResolvableType serdeBeanGeneric = beanDefinition.getResolvableType().getGeneric(new int[]{0});
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found matching Serde<" + serdeBeanGeneric.getType() + "> under beanName=" + beanName));
                }
                matchingSerdes.add(new SerdeWithSpecificityScore(SerdeResolverUtils.calculateScore(targetType, serdeBeanGeneric), (String)beanName));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Failed introspecting Serde bean '" + beanName + "'"), (Throwable)ex);
            }
        });
        if (!matchingSerdes.isEmpty()) {
            return matchingSerdes.stream().sorted(Collections.reverseOrder()).map(SerdeWithSpecificityScore::getSerdeBeanName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static int calculateScore(ResolvableType targetType, ResolvableType typeToScore) {
        int score = SerdeResolverUtils.countLeadingMatchingChars(targetType.getType().getTypeName(), typeToScore.getType().getTypeName());
        return score += SerdeResolverUtils.countLeadingMatchingChars(targetType.toString(), typeToScore.toString());
    }

    private static int countLeadingMatchingChars(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        int matchCount = 0;
        for (int i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
            ++matchCount;
        }
        return matchCount;
    }

    private static class SerdeWithSpecificityScore
    implements Comparable<SerdeWithSpecificityScore> {
        private final Integer score;
        private final String serdeBeanName;

        SerdeWithSpecificityScore(Integer score, String serdeBeanName) {
            this.score = Objects.requireNonNull(score);
            this.serdeBeanName = Objects.requireNonNull(serdeBeanName);
        }

        String getSerdeBeanName() {
            return this.serdeBeanName;
        }

        @Override
        public int compareTo(SerdeWithSpecificityScore other) {
            return this.score.compareTo(other.score);
        }
    }
}

