/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.serde;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

@Deprecated
public class MessageConverterDelegateSerde<T>
implements Serde<T> {
    private static final String VALUE_CLASS_HEADER = "valueClass";
    private static final String AVRO_FORMAT = "avro";
    private static final MimeType DEFAULT_AVRO_MIME_TYPE = new MimeType("application", "*+avro");
    private final MessageConverterDelegateDeserializer<T> messageConverterDelegateDeserializer;
    private final MessageConverterDelegateSerializer<T> messageConverterDelegateSerializer;

    public MessageConverterDelegateSerde(CompositeMessageConverter compositeMessageConverter) {
        this.messageConverterDelegateDeserializer = new MessageConverterDelegateDeserializer(compositeMessageConverter);
        this.messageConverterDelegateSerializer = new MessageConverterDelegateSerializer(compositeMessageConverter);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.messageConverterDelegateDeserializer.configure(configs, isKey);
        this.messageConverterDelegateSerializer.configure(configs, isKey);
    }

    public void close() {
    }

    public Serializer<T> serializer() {
        return this.messageConverterDelegateSerializer;
    }

    public Deserializer<T> deserializer() {
        return this.messageConverterDelegateDeserializer;
    }

    private static MimeType resolveMimeType(Map<String, ?> configs) {
        if (configs.containsKey("contentType")) {
            String contentType = (String)configs.get("contentType");
            if (DEFAULT_AVRO_MIME_TYPE.equals((Object)MimeTypeUtils.parseMimeType((String)contentType))) {
                return DEFAULT_AVRO_MIME_TYPE;
            }
            if (contentType.contains(AVRO_FORMAT)) {
                return MimeTypeUtils.parseMimeType((String)"application/avro");
            }
            return new MimeType("application", "json", StandardCharsets.UTF_8);
        }
        return new MimeType("application", "json", StandardCharsets.UTF_8);
    }

    private static class MessageConverterDelegateSerializer<V>
    implements Serializer<V> {
        private final MessageConverter messageConverter;
        private MimeType mimeType;

        MessageConverterDelegateSerializer(CompositeMessageConverter compositeMessageConverter) {
            this.messageConverter = compositeMessageConverter;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.mimeType = MessageConverterDelegateSerde.resolveMimeType(configs);
        }

        public byte[] serialize(String topic, V data) {
            Message message = MessageBuilder.withPayload(data).build();
            HashMap<String, String> headers = new HashMap<String, String>((Map<String, String>)message.getHeaders());
            headers.put("contentType", this.mimeType.toString());
            MessageHeaders messageHeaders = new MessageHeaders(headers);
            Object payload = this.messageConverter.toMessage(message.getPayload(), messageHeaders).getPayload();
            return (byte[])payload;
        }

        public void close() {
        }
    }

    private static class MessageConverterDelegateDeserializer<U>
    implements Deserializer<U> {
        private final MessageConverter messageConverter;
        private MimeType mimeType;
        private Class<?> valueClass;

        MessageConverterDelegateDeserializer(CompositeMessageConverter compositeMessageConverter) {
            this.messageConverter = compositeMessageConverter;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            Assert.isTrue((boolean)configs.containsKey(MessageConverterDelegateSerde.VALUE_CLASS_HEADER), (String)"Deserializers must provide a configuration for valueClass.");
            Object valueClass = configs.get(MessageConverterDelegateSerde.VALUE_CLASS_HEADER);
            Assert.isTrue((boolean)(valueClass instanceof Class), (String)"Deserializers must provide a valid value for valueClass.");
            this.valueClass = (Class)valueClass;
            this.mimeType = MessageConverterDelegateSerde.resolveMimeType(configs);
        }

        public U deserialize(String topic, byte[] data) {
            Message message = MessageBuilder.withPayload((Object)data).setHeader("contentType", (Object)this.mimeType.toString()).build();
            Object messageConverted = this.messageConverter.fromMessage(message, this.valueClass);
            Assert.notNull((Object)messageConverted, (String)"Deserialization failed.");
            return (U)messageConverted;
        }

        public void close() {
        }
    }
}

