/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsFunctionProcessor;
import org.springframework.cloud.stream.binder.kafka.streams.function.KafkaStreamsBindableProxyFactory;
import org.springframework.core.ResolvableType;

public class KafkaStreamsFunctionProcessorInvoker {
    private final KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor;
    private final Map<String, ResolvableType> resolvableTypeMap;
    private final KafkaStreamsBindableProxyFactory[] kafkaStreamsBindableProxyFactories;
    private final Map<String, Method> methods;

    public KafkaStreamsFunctionProcessorInvoker(Map<String, ResolvableType> resolvableTypeMap, KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor, KafkaStreamsBindableProxyFactory[] kafkaStreamsBindableProxyFactories, Map<String, Method> methods) {
        this.kafkaStreamsFunctionProcessor = kafkaStreamsFunctionProcessor;
        this.resolvableTypeMap = resolvableTypeMap;
        this.kafkaStreamsBindableProxyFactories = kafkaStreamsBindableProxyFactories;
        this.methods = methods;
    }

    @PostConstruct
    void invoke() {
        this.resolvableTypeMap.forEach((key, value) -> {
            Optional<KafkaStreamsBindableProxyFactory> proxyFactory = Arrays.stream(this.kafkaStreamsBindableProxyFactories).filter(p -> p.getFunctionName().equals(key)).findFirst();
            this.kafkaStreamsFunctionProcessor.setupFunctionInvokerForKafkaStreams((ResolvableType)value, (String)key, proxyFactory.get(), this.methods.get(key));
        });
    }
}

