/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Set;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.StreamsListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

class StreamsBuilderFactoryManager
implements SmartLifecycle {
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private final KafkaStreamsRegistry kafkaStreamsRegistry;
    private final KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics;
    private final StreamsListener listener;
    private volatile boolean running;

    StreamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics, StreamsListener listener) {
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
        this.kafkaStreamsBinderMetrics = kafkaStreamsBinderMetrics;
        this.listener = listener;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                int n = 0;
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.start();
                    this.kafkaStreamsRegistry.registerKafkaStreams(streamsBuilderFactoryBean);
                    if (this.listener == null) continue;
                    this.listener.streamsAdded("streams." + n++, streamsBuilderFactoryBean.getKafkaStreams());
                }
                if (this.kafkaStreamsBinderMetrics != null) {
                    this.kafkaStreamsBinderMetrics.addMetrics(streamsBuilderFactoryBeans);
                }
                this.running = true;
            }
            catch (Exception ex) {
                throw new KafkaException("Could not start stream: ", (Throwable)ex);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                int n = 0;
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.stop();
                    if (this.listener == null) continue;
                    this.listener.streamsRemoved("streams." + n++, streamsBuilderFactoryBean.getKafkaStreams());
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 2147483547;
    }
}

