/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class FunctionDetectorCondition
extends SpringBootCondition {
    private static final Log LOG = LogFactory.getLog(FunctionDetectorCondition.class);

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (context != null && context.getBeanFactory() != null) {
            String[] functionTypes = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), Function.class, (boolean)true, (boolean)false);
            String[] consumerTypes = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), Consumer.class, (boolean)true, (boolean)false);
            String[] biFunctionTypes = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), BiFunction.class, (boolean)true, (boolean)false);
            String[] biConsumerTypes = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), BiConsumer.class, (boolean)true, (boolean)false);
            ArrayList<String> functionComponents = new ArrayList<String>();
            functionComponents.addAll(Arrays.asList(functionTypes));
            functionComponents.addAll(Arrays.asList(consumerTypes));
            functionComponents.addAll(Arrays.asList(biFunctionTypes));
            functionComponents.addAll(Arrays.asList(biConsumerTypes));
            List<String> kafkaStreamsFunctions = FunctionDetectorCondition.pruneFunctionBeansForKafkaStreams(functionComponents, context);
            if (!CollectionUtils.isEmpty(kafkaStreamsFunctions)) {
                return ConditionOutcome.match((String)"Matched. Function/BiFunction/Consumer beans found");
            }
            return ConditionOutcome.noMatch((String)"No match. No Function/BiFunction/Consumer beans found");
        }
        return ConditionOutcome.noMatch((String)"No match. No Function/BiFunction/Consumer beans found");
    }

    private static List<String> pruneFunctionBeansForKafkaStreams(List<String> strings, ConditionContext context) {
        ArrayList<String> prunedList = new ArrayList<String>();
        for (String key : strings) {
            Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)context.getBeanFactory().getBeanDefinition(key)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            try {
                Method method;
                ResolvableType resolvableType;
                Class rawClass;
                Method[] methods = classObj.getMethods();
                Optional<Method> kafkaStreamMethod = Arrays.stream(methods).filter(m -> m.getName().equals(key)).findFirst();
                if (!kafkaStreamMethod.isPresent() || (rawClass = (resolvableType = ResolvableType.forMethodReturnType((Method)(method = kafkaStreamMethod.get()), (Class)classObj)).getGeneric(new int[]{0}).getRawClass()) != KStream.class && rawClass != KTable.class && rawClass != GlobalKTable.class) continue;
                prunedList.add(key);
            }
            catch (Exception e) {
                LOG.error((Object)("Function not found: " + key), (Throwable)e);
            }
        }
        return prunedList;
    }
}

