/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.rabbit;

import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.support.converter.JacksonJsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.batch.infrastructure.item.amqp.AmqpItemReader;
import org.springframework.batch.infrastructure.item.amqp.builder.AmqpItemReaderBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.rabbit.AmqpItemReaderProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={AmqpItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.batch.job.amqpitemreader.enabled"}, havingValue="true", matchIfMissing=false)
public class AmqpItemReaderAutoConfiguration {
    @Autowired(required=false)
    private RabbitProperties rabbitProperties;

    @Bean
    public AmqpItemReaderProperties amqpItemReaderProperties() {
        return new AmqpItemReaderProperties();
    }

    @Bean
    public AmqpItemReader<Map<String, Object>> amqpItemReader(AmqpTemplate amqpTemplate, @Autowired(required=false) Class itemType) {
        AmqpItemReaderBuilder builder = new AmqpItemReaderBuilder().amqpTemplate(amqpTemplate);
        if (itemType != null) {
            builder.itemType(itemType);
        }
        return builder.build();
    }

    @ConditionalOnProperty(name={"spring.batch.job.amqpitemreader.jsonConverterEnabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MessageConverter messageConverter() {
        return new JacksonJsonMessageConverter();
    }
}

