/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure;

import java.util.Map;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.infrastructure.item.ItemProcessor;
import org.springframework.batch.infrastructure.item.ItemReader;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.SingleStepJobProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@AutoConfiguration
@EnableConfigurationProperties(value={SingleStepJobProperties.class})
@AutoConfigureBefore(value={BatchAutoConfiguration.class})
public class SingleStepJobAutoConfiguration {
    private SingleStepJobProperties properties;
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    JobRepository jobRepository;
    @Autowired(required=false)
    private ItemProcessor<Map<String, Object>, Map<String, Object>> itemProcessor;

    public SingleStepJobAutoConfiguration(SingleStepJobProperties properties, ApplicationContext context) {
        this.validateProperties(properties);
        this.properties = properties;
    }

    private void validateProperties(SingleStepJobProperties properties) {
        Assert.hasText((String)properties.getJobName(), (String)"A job name is required");
        Assert.hasText((String)properties.getStepName(), (String)"A step name is required");
        Assert.notNull((Object)properties.getChunkSize(), (String)"A chunk size is required");
        Assert.isTrue((properties.getChunkSize() > 0 ? 1 : 0) != 0, (String)"A chunk size greater than zero is required");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job", name={"job-name"})
    public Job job(ItemReader<Map<String, Object>> itemReader, ItemWriter<Map<String, Object>> itemWriter) {
        SimpleStepBuilder stepBuilder = new StepBuilder(this.properties.getStepName(), this.jobRepository).chunk(this.properties.getChunkSize().intValue(), this.transactionManager).reader(itemReader);
        stepBuilder.processor(this.itemProcessor);
        TaskletStep step = stepBuilder.writer(itemWriter).build();
        return new JobBuilder(this.properties.getJobName(), this.jobRepository).start((Step)step).build();
    }
}

