/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.database.builder.JdbcBatchItemWriterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JdbcBatchItemWriterProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JdbcBatchItemWriterProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class JdbcBatchItemWriterAutoConfiguration {
    @Autowired(required=false)
    private ItemPreparedStatementSetter itemPreparedStatementSetter;
    @Autowired(required=false)
    private ItemSqlParameterSourceProvider itemSqlParameterSourceProvider;
    private JdbcBatchItemWriterProperties properties;
    private DataSource dataSource;

    public JdbcBatchItemWriterAutoConfiguration(DataSource dataSource, JdbcBatchItemWriterProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.jdbcbatchitemwriter", name={"name"})
    public JdbcBatchItemWriter<Map<String, Object>> itemWriter() {
        JdbcBatchItemWriterBuilder jdbcBatchItemWriterBuilder = new JdbcBatchItemWriterBuilder().dataSource(this.dataSource).sql(this.properties.getSql());
        if (this.itemPreparedStatementSetter != null) {
            jdbcBatchItemWriterBuilder.itemPreparedStatementSetter(this.itemPreparedStatementSetter);
        } else if (this.itemSqlParameterSourceProvider != null) {
            jdbcBatchItemWriterBuilder.itemSqlParameterSourceProvider(this.itemSqlParameterSourceProvider);
        } else {
            jdbcBatchItemWriterBuilder.columnMapped();
        }
        jdbcBatchItemWriterBuilder.assertUpdates(this.properties.isAssertUpdates());
        return jdbcBatchItemWriterBuilder.build();
    }
}

