/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.cloud.dataflow.metrics.collector.model.Metric;

@JsonComponent
public class MetricJsonSerializer {
    private static final BlockingQueue<InternalFormatters> formattersQueue = new LinkedBlockingQueue<InternalFormatters>();

    static class InternalFormatters {
        final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        final DecimalFormat decimalFormat;

        public InternalFormatters() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.decimalFormat = new DecimalFormat("#.##");
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public DecimalFormat getDecimalFormat() {
            return this.decimalFormat;
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Metric> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Metric deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String name = node.get("name").asText();
            Double value = node.get("value").asDouble();
            Date timestamp = null;
            InternalFormatters formatters = (InternalFormatters)formattersQueue.poll();
            if (formatters == null) {
                formatters = new InternalFormatters();
            }
            try {
                timestamp = formatters.getDateFormat().parse(node.get("timestamp").asText());
            }
            catch (ParseException parseException) {
            }
            finally {
                formattersQueue.offer(formatters);
            }
            Metric<Double> metric = new Metric<Double>(name, value, timestamp);
            return metric;
        }
    }

    public static class Serializer
    extends JsonSerializer<Metric> {
        public void serialize(Metric metric, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            InternalFormatters formatters = (InternalFormatters)formattersQueue.poll();
            if (formatters == null) {
                formatters = new InternalFormatters();
            }
            json.writeStringField("name", metric.getName());
            try {
                json.writeNumberField("value", formatters.getDecimalFormat().parse(formatters.getDecimalFormat().format(((Number)metric.getValue()).doubleValue())).doubleValue());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            json.writeStringField("timestamp", formatters.getDateFormat().format(metric.getTimestamp()));
            json.writeEndObject();
            formattersQueue.offer(formatters);
        }
    }
}

