/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.lang.Nullable;
import java.util.Date;
import java.util.List;

@JsonPropertyOrder(value={"id", "timestamp", "sum", "count", "mean", "upper", "total"})
public class MicrometerMetric<T extends Number> {
    private Date timestamp;
    private Id id;
    private Number sum = 0.0;
    private Number count = 0.0;
    private Number mean = 0.0;
    private Number upper = 0.0;
    private Number total = 0.0;

    public Id getId() {
        return this.id;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public Number getSum() {
        return this.sum;
    }

    public Number getCount() {
        return this.count;
    }

    public Number getMean() {
        return this.mean;
    }

    public Number getUpper() {
        return this.upper;
    }

    public Number getTotal() {
        return this.total;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setSum(Number sum) {
        this.sum = sum;
    }

    public void setCount(Number count) {
        this.count = count;
    }

    public void setMean(Number mean) {
        this.mean = mean;
    }

    public void setUpper(Number upper) {
        this.upper = upper;
    }

    public void setTotal(Number total) {
        this.total = total;
    }

    public String toString() {
        return "MicrometerMetric [id=" + this.id + ", sum=" + this.sum + ", count=" + this.count + ", mean=" + this.mean + ", upper=" + this.upper + ", total=" + this.total + ", timestamp=" + this.timestamp + "]";
    }

    public static class Id {
        private String name;
        private List<Tag> tags;
        private Meter.Type type;
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public void setTags(List<Tag> tags) {
            this.tags = tags;
        }

        public Meter.Type getType() {
            return this.type;
        }

        public void setType(Meter.Type type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public void setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
        }

        public String getTag(String key) {
            for (Tag tag : this.tags) {
                if (!tag.getKey().equals(key)) continue;
                return tag.getValue();
            }
            return null;
        }
    }

    public static class Tag {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

